/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.model.impl.MBTreeWalkerImpl;
import com.liferay.portal.util.PropsValues;
import java.util.List;

public class MBMessageDisplayImpl
implements MBMessageDisplay {
    private final MBCategory _category;
    private final int _discussionMessagesCount;
    private final MBMessage _message;
    private final MBMessage _parentMessage;
    private final MBThread _thread;
    private final MBTreeWalker _treeWalker;

    public MBMessageDisplayImpl(MBMessage message, MBMessage parentMessage, List<MBMessage> messages, MBCategory category, MBThread thread, int discussionMessagesCount) {
        this._message = message;
        this._parentMessage = parentMessage;
        this._category = category;
        this._thread = thread;
        this._discussionMessagesCount = discussionMessagesCount;
        this._treeWalker = new MBTreeWalkerImpl(messages);
    }

    public MBCategory getCategory() {
        return this._category;
    }

    public MBMessage getMessage() {
        return this._message;
    }

    public MBMessage getParentMessage() {
        return this._parentMessage;
    }

    public MBThread getThread() {
        return this._thread;
    }

    public MBTreeWalker getTreeWalker() {
        return this._treeWalker;
    }

    public boolean isDiscussionMaxComments() {
        return this._message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0 && PropsValues.DISCUSSION_MAX_COMMENTS <= this._discussionMessagesCount;
    }
}

