/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBThreadLocalServiceUtil;

/**
 * The extended model base implementation for the MBThread service. Represents a row in the &quot;MBThread&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBThreadImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBThreadImpl
 * @see MBThread
 * @generated
 */
public abstract class MBThreadBaseImpl
	extends MBThreadModelImpl implements MBThread {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards thread model instance should use the <code>MBThread</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MBThreadLocalServiceUtil.addMBThread(this);
		}
		else {
			MBThreadLocalServiceUtil.updateMBThread(this);
		}
	}

}