/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBMessageTable;
import com.liferay.message.boards.model.MBStatsUser;
import com.liferay.message.boards.model.MBThreadTable;
import com.liferay.message.boards.model.impl.MBStatsUserImpl;
import com.liferay.message.boards.service.base.MBStatsUserLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.message.boards.service.persistence.MBThreadPersistence;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Alias;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBStatsUser"}, service={AopService.class})
public class MBStatsUserLocalServiceImpl
extends MBStatsUserLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MBStatsUserLocalServiceImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private MBMessagePersistence _mbMessagePersistence;
    @Reference
    private MBThreadPersistence _mbThreadPersistence;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Date getLastPostDateByUserId(long groupId, long userId) {
        List results = (List)this._mbThreadPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.max((Expression)MBThreadTable.INSTANCE.lastPostDate).as("maxLastPostDate")}).from((Table)MBThreadTable.INSTANCE).where(MBThreadTable.INSTANCE.userId.eq((Object)userId).and((Expression)MBThreadTable.INSTANCE.status.neq((Object)8))));
        return (Date)results.get(0);
    }

    public int getMessageCount(long groupId, long userId) {
        return this._mbMessagePersistence.countByG_U_S(groupId, userId, 0);
    }

    public long getMessageCountByGroupId(long groupId) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        return (Long)this._mbMessagePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.count().from((Table)MBMessageTable.INSTANCE).where(MBMessageTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)MBMessageTable.INSTANCE.userId.neq((Object)this._userLocalService.getGuestUserId(group.getCompanyId()))).and((Expression)MBMessageTable.INSTANCE.categoryId.neq((Object)-1L)).and((Expression)MBMessageTable.INSTANCE.status.eq((Object)0))));
    }

    public long getMessageCountByUserId(long userId) {
        return (Long)this._mbMessagePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.count().from((Table)MBMessageTable.INSTANCE).where(MBMessageTable.INSTANCE.userId.eq((Object)userId).and((Expression)MBMessageTable.INSTANCE.categoryId.neq((Object)-1L)).and((Expression)MBMessageTable.INSTANCE.status.eq((Object)0))));
    }

    public List<MBStatsUser> getStatsUsersByGroupId(long groupId, int start, int end) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        long guestUserId = this._userLocalService.getGuestUserId(group.getCompanyId());
        Alias countExpression = DSLFunctionFactoryUtil.count((Expression)MBMessageTable.INSTANCE.messageId).as("messageCount");
        List rows = (List)this._mbMessagePersistence.dslQuery(DSLQueryFactoryUtil.select((Expression[])new Expression[]{MBMessageTable.INSTANCE.userId, countExpression, DSLFunctionFactoryUtil.max((Expression)MBMessageTable.INSTANCE.modifiedDate).as("lastPostDate")}).from((Table)MBMessageTable.INSTANCE).where(MBMessageTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)MBMessageTable.INSTANCE.userId.neq((Object)guestUserId)).and((Expression)MBMessageTable.INSTANCE.categoryId.neq((Object)-1L)).and((Expression)MBMessageTable.INSTANCE.status.eq((Object)0))).groupBy(new Expression[]{MBMessageTable.INSTANCE.userId}).orderBy(new OrderByExpression[]{countExpression.descending()}).limit(start, end));
        ArrayList<MBStatsUser> mbStatsUsers = new ArrayList<MBStatsUser>(rows.size());
        for (Object[] columns : rows) {
            Long userId = (Long)columns[0];
            Long messageCount = (Long)columns[1];
            Date lastPostDate = (Date)columns[2];
            mbStatsUsers.add(new MBStatsUserImpl(userId, messageCount.intValue(), lastPostDate));
        }
        return mbStatsUsers;
    }

    public int getStatsUsersByGroupIdCount(long groupId) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        return this._mbMessagePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)MBMessageTable.INSTANCE.userId).from((Table)MBMessageTable.INSTANCE).where(MBMessageTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)MBMessageTable.INSTANCE.userId.neq((Object)this._userLocalService.getGuestUserId(group.getCompanyId()))).and((Expression)MBMessageTable.INSTANCE.categoryId.neq((Object)-1L)).and((Expression)MBMessageTable.INSTANCE.status.eq((Object)0))));
    }

    public String[] getUserRank(long groupId, String languageId, long userId) throws PortalException {
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)groupId);
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        User user = this._userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        String[] ranks = mbGroupServiceSettings.getRanks(languageId);
        int messageCount = this.getMessageCount(groupId, userId);
        for (String curRank : ranks) {
            String[] kvp = StringUtil.split((String)curRank, (char)'=');
            String kvpPosts = kvp[1];
            String[] curRankValueKvp = StringUtil.split((String)kvpPosts, (char)':');
            if (curRankValueKvp.length <= 1) {
                int posts = GetterUtil.getInteger((String)kvpPosts);
                if (posts > messageCount || posts < maxPosts) continue;
                rank[0] = kvp[0];
                maxPosts = posts;
                continue;
            }
            String entityType = curRankValueKvp[0];
            String entityValue = curRankValueKvp[1];
            try {
                if (!this._isEntityRank(companyId, user, entityType, entityValue)) continue;
                rank[1] = kvp[0];
                break;
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)exception);
            }
        }
        return rank;
    }

    private boolean _isEntityRank(long companyId, User statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        long userId = statsUser.getUserId();
        if (entityType.equals("organization-role") || entityType.equals("site-role")) {
            Role role = this._roleLocalService.getRole(companyId, entityValue);
            if (this._userGroupRoleLocalService.hasUserGroupRole(userId, statsUser.getGroupId(), role.getRoleId(), true)) {
                return true;
            }
        } else if (entityType.equals("organization") ? this._organizationLocalService.hasUserOrganization(userId, (organization = this._organizationLocalService.getOrganization(companyId, entityValue)).getOrganizationId(), false, false) : (entityType.equals("regular-role") ? this._roleLocalService.hasUserRole(userId, companyId, entityValue, true) : entityType.equals("user-group") && this._userLocalService.hasUserGroupUser((userGroup = this._userGroupLocalService.getUserGroup(companyId, entityValue)).getUserGroupId(), userId))) {
            return true;
        }
        return false;
    }
}

