/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.utility.page.model.impl;

import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutUtilityPageEntry service. Represents a row in the &quot;LayoutUtilityPageEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutUtilityPageEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutUtilityPageEntryImpl
 * @see LayoutUtilityPageEntry
 * @generated
 */
public abstract class LayoutUtilityPageEntryBaseImpl
	extends LayoutUtilityPageEntryModelImpl implements LayoutUtilityPageEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout utility page entry model instance should use the <code>LayoutUtilityPageEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutUtilityPageEntryLocalServiceUtil.addLayoutUtilityPageEntry(
				this);
		}
		else {
			LayoutUtilityPageEntryLocalServiceUtil.updateLayoutUtilityPageEntry(
				this);
		}
	}

}