/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.upgrade.v3_0_0;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.layout.seo.internal.upgrade.v3_0_0.util.LayoutSEOEntryCustomMetaTagTable;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutSEOEntryCustomMetaTagUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final CompanyLocalService _companyLocalService;
    private final DDMStorageEngineManager _ddmStorageEngineManager;
    private final DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final GroupLocalService _groupLocalService;

    public LayoutSEOEntryCustomMetaTagUpgradeProcess(ClassNameLocalService classNameLocalService, CompanyLocalService companyLocalService, DDMStorageEngineManager ddmStorageEngineManager, DDMStorageLinkLocalService ddmStorageLinkLocalService, DDMStructureLocalService ddmStructureLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._companyLocalService = companyLocalService;
        this._ddmStorageEngineManager = ddmStorageEngineManager;
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, layoutSEOEntryId, groupId, companyId, ddmStorageId from LayoutSEOEntry where ddmStorageId > 0");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into LayoutSEOEntryCustomMetaTag (", "mvccVersion, ctCollectionId, groupId, companyId, ", "layoutSEOEntryCustomMetaTagId, layoutSEOEntryId, ", "property, content) values (?, ?, ?, ?, ?, ?, ?, ?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long ctCollection = resultSet.getLong(1);
                long layoutSEOEntryId = resultSet.getLong(2);
                long groupId = resultSet.getLong(3);
                long companyId2 = resultSet.getLong(4);
                long ddmStorageId = resultSet.getLong(5);
                this._addLayoutSEOEntryCustomMetaTags(companyId2, ctCollection, ddmStorageId, groupId, layoutSEOEntryId, preparedStatement2);
            }
            preparedStatement2.executeBatch();
        }
        this._companyLocalService.forEachCompanyId(companyId -> {
            Group companyGroup = this._groupLocalService.getCompanyGroup(companyId.longValue());
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(companyGroup.getGroupId(), this._classNameLocalService.getClassNameId(LayoutSEOEntry.class.getName()), "custom-meta-tags");
            if (ddmStructure == null) {
                return;
            }
            this._ddmStorageLinkLocalService.deleteStructureStorageLinks(ddmStructure.getStructureId());
            this._ddmStructureLocalService.deleteStructure(ddmStructure);
        });
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"LayoutSEOEntry", (String[])new String[]{"DDMStorageId"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{LayoutSEOEntryCustomMetaTagTable.create()};
    }

    private void _addLayoutSEOEntryCustomMetaTags(long companyId, long ctCollection, long ddmStorageId, long groupId, long layoutSEOEntryId, PreparedStatement preparedStatement) throws Exception {
        DDMFormValues ddmFormValues = this._ddmStorageEngineManager.getDDMFormValues(ddmStorageId);
        for (DDMFormFieldValue nameDDMFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            if (this._isLegacyDDMFormFieldValue(nameDDMFormFieldValue)) {
                List nestedDDMFormFieldValues = nameDDMFormFieldValue.getNestedDDMFormFieldValues();
                nameDDMFormFieldValue = (DDMFormFieldValue)nestedDDMFormFieldValues.get(0);
            }
            Value nameValue = nameDDMFormFieldValue.getValue();
            List nestedDDMFormFieldValues = nameDDMFormFieldValue.getNestedDDMFormFieldValues();
            DDMFormFieldValue valueDDMFormFieldValue = (DDMFormFieldValue)nestedDDMFormFieldValues.get(0);
            Value valueValue = valueDDMFormFieldValue.getValue();
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, ctCollection);
            preparedStatement.setLong(3, groupId);
            preparedStatement.setLong(4, companyId);
            preparedStatement.setLong(5, this.increment());
            preparedStatement.setLong(6, layoutSEOEntryId);
            preparedStatement.setString(7, nameValue.getString(nameValue.getDefaultLocale()));
            HashMap localizedMap = new HashMap();
            Map contentMap = valueValue.getValues();
            contentMap.forEach((locale, value) -> localizedMap.put(LocaleUtil.toLanguageId((Locale)locale), value));
            preparedStatement.setString(8, LocalizationUtil.getXml(localizedMap, (String)LocaleUtil.toLanguageId((Locale)valueValue.getDefaultLocale()), (String)"Label"));
            preparedStatement.addBatch();
        }
        this._ddmStorageEngineManager.deleteByClass(ddmStorageId);
    }

    private boolean _isLegacyDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue) {
        List nestedDDMFormFieldValues = ddmFormFieldValue.getNestedDDMFormFieldValues();
        DDMFormFieldValue childDDMFormFieldValue = (DDMFormFieldValue)nestedDDMFormFieldValues.get(0);
        return Objects.equals(childDDMFormFieldValue.getName(), "property");
    }
}

