/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.canonical.url;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.layout.seo.canonical.url.LayoutSEOCanonicalURLProvider;
import com.liferay.layout.seo.internal.configuration.LayoutSEOCompanyConfiguration;
import com.liferay.layout.seo.internal.util.AlternateURLMapperProvider;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOCanonicalURLProvider.class})
public class LayoutSEOCanonicalURLProviderImpl
implements LayoutSEOCanonicalURLProvider {
    private AlternateURLMapperProvider _alternateURLMapperProvider;
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Language _language;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;

    public String getCanonicalURL(Layout layout, Locale locale, String canonicalURL, ThemeDisplay themeDisplay) throws PortalException {
        String layoutCanonicalURL = this._getLayoutCanonicalURL(locale, layout);
        if (Validator.isNotNull((String)layoutCanonicalURL)) {
            return layoutCanonicalURL;
        }
        return this._getDefaultCanonicalURL(layout, locale, canonicalURL, themeDisplay);
    }

    public Map<Locale, String> getCanonicalURLMap(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        AlternateURLMapperProvider.AlternateURLMapper alternateURLMapper = this._alternateURLMapperProvider.getAlternateURLMapper(this._getHttpServletRequest());
        Map<Locale, String> alternateURLs = alternateURLMapper.getAlternateURLs(this._portal.getCanonicalURL(this._portal.getLayoutFullURL(layout, themeDisplay), themeDisplay, layout, false, false), themeDisplay, layout, this._language.getAvailableLocales(layout.getGroupId()));
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || !layoutSEOEntry.isCanonicalURLEnabled()) {
            return alternateURLs;
        }
        return HashMapBuilder.create(alternateURLs).putAll(layoutSEOEntry.getCanonicalURLMap()).build();
    }

    public String getDefaultCanonicalURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        String canonicalURL = this._portal.getCanonicalURL(this._portal.getLayoutFullURL(layout, themeDisplay), themeDisplay, layout, false, false);
        return this._getDefaultCanonicalURL(layout, themeDisplay.getLocale(), canonicalURL, themeDisplay);
    }

    @Activate
    protected void activate() {
        this._alternateURLMapperProvider = new AlternateURLMapperProvider(this._assetDisplayPageFriendlyURLProvider, this._classNameLocalService, this._portal);
    }

    @Deactivate
    protected void deactivate() {
        this._alternateURLMapperProvider = null;
    }

    private String _getDefaultCanonicalURL(Layout layout, Locale locale, String canonicalURL, ThemeDisplay themeDisplay) throws PortalException {
        LayoutSEOCompanyConfiguration layoutSEOCompanyConfiguration = (LayoutSEOCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(LayoutSEOCompanyConfiguration.class, layout.getCompanyId());
        AlternateURLMapperProvider.AlternateURLMapper alternateURLMapper = this._alternateURLMapperProvider.getAlternateURLMapper(this._getHttpServletRequest());
        if (Objects.equals(layoutSEOCompanyConfiguration.canonicalURL(), "default-language-url")) {
            return alternateURLMapper.getAlternateURL(canonicalURL, themeDisplay, LocaleUtil.getSiteDefault(), layout);
        }
        Set availableLocales = this._language.getAvailableLocales(layout.getGroupId());
        if (!availableLocales.contains(locale)) {
            locale = LocaleUtil.getSiteDefault();
        }
        return alternateURLMapper.getAlternateURL(canonicalURL, themeDisplay, locale, layout);
    }

    private HttpServletRequest _getHttpServletRequest() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            return serviceContext.getRequest();
        }
        return null;
    }

    private String _getLayoutCanonicalURL(Locale locale, Layout layout) {
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || !layoutSEOEntry.isCanonicalURLEnabled()) {
            return "";
        }
        return layoutSEOEntry.getCanonicalURL(locale);
    }
}

