/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.impl;

import com.liferay.layout.seo.model.LayoutSEOSite;
import com.liferay.layout.seo.service.base.LayoutSEOSiteLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.layout.seo.model.LayoutSEOSite"}, service={AopService.class})
public class LayoutSEOSiteLocalServiceImpl
extends LayoutSEOSiteLocalServiceBaseImpl {
    public LayoutSEOSite fetchLayoutSEOSiteByGroupId(long groupId) {
        return this.layoutSEOSitePersistence.fetchByGroupId(groupId);
    }

    public LayoutSEOSite updateLayoutSEOSite(long userId, long groupId, boolean openGraphEnabled, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutSEOSite layoutSEOSite = this.layoutSEOSitePersistence.fetchByGroupId(groupId);
        if (layoutSEOSite == null) {
            return this._addLayoutSEOSite(userId, groupId, openGraphEnabled, openGraphImageAltMap, openGraphImageFileEntryId, serviceContext);
        }
        layoutSEOSite.setModifiedDate(new Date());
        layoutSEOSite.setOpenGraphEnabled(openGraphEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOSite.setOpenGraphImageAltMap(openGraphImageAltMap);
        } else {
            layoutSEOSite.setOpenGraphImageAltMap(Collections.emptyMap());
        }
        layoutSEOSite.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        return (LayoutSEOSite)this.layoutSEOSitePersistence.update((BaseModel)layoutSEOSite);
    }

    private LayoutSEOSite _addLayoutSEOSite(long userId, long groupId, boolean openGraphEnabled, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutSEOSite layoutSEOSite = this.layoutSEOSitePersistence.create(this.counterLocalService.increment());
        layoutSEOSite.setUuid(serviceContext.getUuid());
        layoutSEOSite.setGroupId(groupId);
        Group group = this.groupLocalService.getGroup(groupId);
        layoutSEOSite.setCompanyId(group.getCompanyId());
        layoutSEOSite.setUserId(userId);
        layoutSEOSite.setCreateDate(new Date());
        layoutSEOSite.setModifiedDate(new Date());
        layoutSEOSite.setOpenGraphEnabled(openGraphEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOSite.setOpenGraphImageAltMap(openGraphImageAltMap);
        }
        layoutSEOSite.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        return (LayoutSEOSite)this.layoutSEOSitePersistence.update((BaseModel)layoutSEOSite);
    }
}

