/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.layout.seo.canonical.url.LayoutSEOCanonicalURLProvider;
import com.liferay.layout.seo.internal.LayoutSEOLinkImpl;
import com.liferay.layout.seo.internal.util.FriendlyURLMapperProvider;
import com.liferay.layout.seo.kernel.LayoutSEOLink;
import com.liferay.layout.seo.kernel.LayoutSEOLinkManager;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.open.graph.OpenGraphConfiguration;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOLinkManager.class})
public class LayoutSEOLinkManagerImpl
implements LayoutSEOLinkManager {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOLinkManagerImpl.class);
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private FriendlyURLMapperProvider _friendlyURLMapperProvider;
    @Reference
    private Html _html;
    @Reference
    private Language _language;
    @Reference
    private LayoutSEOCanonicalURLProvider _layoutSEOCanonicalURLProvider;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private OpenGraphConfiguration _openGraphConfiguration;
    @Reference
    private Portal _portal;

    public LayoutSEOLink getCanonicalLayoutSEOLink(Layout layout, Locale locale, String canonicalURL, Map<Locale, String> alternateURLs) throws PortalException {
        return new LayoutSEOLinkImpl(this._html.escapeAttribute(this._layoutSEOCanonicalURLProvider.getCanonicalURL(layout, locale, canonicalURL, alternateURLs)), null, LayoutSEOLink.Relationship.CANONICAL);
    }

    public String getFullPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, String companyName, Locale locale) throws PortalException {
        String layoutTitle = this._getPageTitle(layout, portletId, tilesTitle, titleListMergeable, subtitleListMergeable, locale);
        String siteAndCompanyName = this._getPageTitleSuffix(layout, companyName);
        return this._merge(layoutTitle, siteAndCompanyName);
    }

    public List<LayoutSEOLink> getLocalizedLayoutSEOLinks(Layout layout, Locale locale, String canonicalURL, Map<Locale, String> alternateURLs) throws PortalException {
        ArrayList<LayoutSEOLink> layoutSEOLinks = new ArrayList<LayoutSEOLink>(alternateURLs.size() + 2);
        layoutSEOLinks.add(this.getCanonicalLayoutSEOLink(layout, locale, canonicalURL, alternateURLs));
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        FriendlyURLMapperProvider.FriendlyURLMapper friendlyURLMapper = this._friendlyURLMapperProvider.getFriendlyURLMapper(themeDisplay.getRequest());
        Map<Locale, String> mappedFriendlyURLs = friendlyURLMapper.getMappedFriendlyURLs(alternateURLs);
        mappedFriendlyURLs.forEach((urlLocale, url) -> layoutSEOLinks.add(new LayoutSEOLinkImpl(this._html.escapeAttribute(this._getAlternateCustomCanonicalURL(layout, (Locale)urlLocale, (String)url)), LocaleUtil.toW3cLanguageId((Locale)urlLocale), LayoutSEOLink.Relationship.ALTERNATE)));
        String defaultLocaleURL = alternateURLs.get(this._portal.getSiteDefaultLocale(layout.getGroupId()));
        if (defaultLocaleURL == null) {
            return layoutSEOLinks;
        }
        layoutSEOLinks.add(new LayoutSEOLinkImpl(this._html.escapeAttribute(defaultLocaleURL), "x-default", LayoutSEOLink.Relationship.ALTERNATE));
        return layoutSEOLinks;
    }

    public String getPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, Locale locale) throws PortalException {
        return this._html.escape(this._getPageTitle(layout, portletId, tilesTitle, titleListMergeable, subtitleListMergeable, locale));
    }

    public String getPageTitleSuffix(Layout layout, String companyName) throws PortalException {
        return this._html.escape(this._getPageTitleSuffix(layout, companyName));
    }

    @Deprecated
    public boolean isOpenGraphEnabled(Layout layout) throws PortalException {
        return this._openGraphConfiguration.isOpenGraphEnabled(layout.getGroup());
    }

    @Activate
    protected void activate() {
        this._friendlyURLMapperProvider = new FriendlyURLMapperProvider(this._assetDisplayPageFriendlyURLProvider, this._classNameLocalService);
    }

    @Deactivate
    protected void deactivate() {
        this._friendlyURLMapperProvider = null;
    }

    private String _getAlternateCustomCanonicalURL(Layout layout, Locale locale, String alternateURL) {
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || !layoutSEOEntry.isCanonicalURLEnabled()) {
            return alternateURL;
        }
        Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
        try {
            siteDefaultLocale = this._portal.getSiteDefaultLocale(layout.getGroupId());
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
        String currentCanonicalURL = layoutSEOEntry.getCanonicalURL(siteDefaultLocale);
        String alternateCanonicalURL = layoutSEOEntry.getCanonicalURL(locale);
        if (currentCanonicalURL.equals(alternateCanonicalURL)) {
            return alternateURL;
        }
        return alternateCanonicalURL;
    }

    private String _getPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, Locale locale) throws PortalException {
        if (Validator.isNotNull((String)portletId) && layout.isSystem() && !layout.isTypeControlPanel() && StringUtil.equals((String)layout.getFriendlyURL(), (String)"/manage")) {
            return this._portal.getPortletTitle(portletId, locale);
        }
        if (Validator.isNotNull((String)tilesTitle)) {
            return this._language.get(locale, tilesTitle);
        }
        if (subtitleListMergeable == null) {
            return this._getTitle(layout, titleListMergeable, locale);
        }
        return this._merge(subtitleListMergeable.mergeToString(" "), this._getTitle(layout, titleListMergeable, locale));
    }

    private String _getPageTitleSuffix(Layout layout, String companyName) throws PortalException {
        Group group = layout.getGroup();
        if (group.isControlPanel() || group.isLayoutPrototype() || StringUtil.equals((String)companyName, (String)group.getDescriptiveName())) {
            return companyName;
        }
        return this._merge(group.getDescriptiveName(), companyName);
    }

    private ThemeDisplay _getThemeDisplay() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            return serviceContext.getThemeDisplay();
        }
        return null;
    }

    private String _getTitle(Layout layout, ListMergeable<String> titleListMergeable, Locale locale) throws PortalException {
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            return group.getDescriptiveName(locale);
        }
        if (titleListMergeable != null) {
            return titleListMergeable.mergeToString(" ");
        }
        return layout.getHTMLTitle(this._language.getLanguageId(locale));
    }

    private String _merge(String ... strings) {
        return StringUtil.merge((Object[])strings, (String)" - ");
    }
}

