/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_3_3;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class KBFolderUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        Map<Long, String> urlTitles = this._getInitialUrlTitles(this.connection);
        for (Map.Entry<Long, String> entry : urlTitles.entrySet()) {
            String uniqueUrlTitle = this._findUniqueUrlTitle(this.connection, entry.getValue());
            int i = 1;
            while (uniqueUrlTitle == null) {
                uniqueUrlTitle = this._findUniqueUrlTitle(this.connection, entry.getValue() + "-" + i);
                ++i;
            }
            this._updateKBFolder(this.connection, entry.getKey(), uniqueUrlTitle);
        }
    }

    private String _findUniqueUrlTitle(Connection connection, String urlTitle) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from KBFolder where KBFolder.urlTitle like ?");){
            String string;
            block20: {
                ResultSet resultSet;
                block18: {
                    String string2;
                    block19: {
                        block16: {
                            String string3;
                            block17: {
                                preparedStatement.setString(1, urlTitle + "%");
                                resultSet = preparedStatement.executeQuery();
                                try {
                                    if (resultSet.next()) break block16;
                                    string3 = urlTitle;
                                    if (resultSet == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                resultSet.close();
                            }
                            return string3;
                        }
                        int kbFolderCount = resultSet.getInt(1);
                        if (kbFolderCount != 0) break block18;
                        string2 = urlTitle;
                        if (resultSet == null) break block19;
                        resultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return string;
        }
    }

    private Map<Long, String> _getInitialUrlTitles(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select kbFolderId, name from KBFolder where (KBFolder.urlTitle is null) or (KBFolder.urlTitle = '')");){
            HashMap<Long, String> hashMap;
            block13: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    HashMap<Long, String> urlTitles = new HashMap<Long, String>();
                    while (resultSet.next()) {
                        long kbFolderId = resultSet.getLong(1);
                        String name = resultSet.getString(2);
                        String urlTitle = this._getUrlTitle(kbFolderId, name);
                        urlTitles.put(kbFolderId, urlTitle);
                    }
                    hashMap = urlTitles;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return hashMap;
        }
    }

    private String _getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)title);
        return title.substring(0, 75);
    }

    private void _updateKBFolder(Connection connection, long kbFolderId, String urlTitle) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update KBFolder set KBFolder.urlTitle = ? where KBFolder.kbFolderId = ?");){
            preparedStatement.setString(1, urlTitle);
            preparedStatement.setLong(2, kbFolderId);
            preparedStatement.execute();
        }
    }
}

