/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_3_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class KBAttachmentsUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_KB_ARTICLE = "com.liferay.knowledgebase.model.KBArticle";
    private static final String _PORTLET_ID = "3_WAR_knowledgebaseportlet";
    private static final Log _log = LogFactoryUtil.getLog(KBAttachmentsUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final PortletFileRepository _portletFileRepository;
    private final Store _store;

    public KBAttachmentsUpgradeProcess(CompanyLocalService companyLocalService, PortletFileRepository portletFileRepository, Store store) {
        this._companyLocalService = companyLocalService;
        this._portletFileRepository = portletFileRepository;
        this._store = store;
    }

    protected void doUpgrade() throws Exception {
        this._updateAttachments();
        this._deleteEmptyDirectories();
    }

    private void _deleteEmptyDirectories() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> this._store.deleteDirectory(companyId.longValue(), 0L, "knowledgebase/kbarticles"));
    }

    private String[] _getAttachments(long companyId, long resourcePrimKey) throws Exception {
        String dirName = "knowledgebase/kbarticles/" + resourcePrimKey;
        return this._store.getFileNames(companyId, 0L, dirName);
    }

    private long _getFolderId(long groupId, long userId, long resourcePrimKey) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this._portletFileRepository.addPortletRepository(groupId, _PORTLET_ID, serviceContext);
        Folder folder = this._portletFileRepository.addPortletFolder(userId, repository.getRepositoryId(), 0L, String.valueOf(resourcePrimKey), serviceContext);
        return folder.getFolderId();
    }

    private void _updateAttachments() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select kbArticleId, resourcePrimKey, groupId, companyId, userId, status from KBArticle");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long classPK = resultSet.getLong("resourcePrimKey");
                int status = resultSet.getInt("status");
                if (status != 0) {
                    classPK = resultSet.getLong("kbArticleId");
                }
                long userId = resultSet.getLong("userId");
                this._updateAttachments(companyId, groupId, classPK, userId);
            }
        }
    }

    private void _updateAttachments(long companyId, long groupId, long resourcePrimKey, long userId) throws Exception {
        for (String attachment : this._getAttachments(companyId, resourcePrimKey)) {
            try {
                if (!this._store.hasFile(companyId, 0L, attachment, "1.0")) continue;
                long folderId = this._getFolderId(groupId, userId, resourcePrimKey);
                byte[] bytes = StreamUtil.toByteArray((InputStream)this._store.getFileAsStream(companyId, 0L, attachment, ""));
                String title = FileUtil.getShortFileName((String)attachment);
                String mimeType = MimeTypesUtil.getExtensionContentType((String)FileUtil.getExtension((String)title));
                this._portletFileRepository.addPortletFileEntry(groupId, userId, _CLASS_NAME_KB_ARTICLE, resourcePrimKey, _PORTLET_ID, folderId, bytes, title, mimeType, false);
                for (String versionLabel : this._store.getFileVersions(companyId, 0L, attachment)) {
                    this._store.deleteFile(companyId, 0L, attachment, versionLabel);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to upgrade attachment " + attachment), (Throwable)portalException);
            }
        }
    }
}

