/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import java.util.ArrayList;
import java.util.Locale;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Indexer.class})
public class KBArticleIndexer
extends BaseIndexer<KBArticle> {
    public static final String CLASS_NAME = KBArticle.class.getName();
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected KBArticleLocalService kbArticleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(KBArticleIndexer.class);
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    private ServiceTrackerList<ModelDocumentContributor<KBArticle>> _serviceTrackerList;

    public KBArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "content", "createDate", "description", "entryClassName", "entryClassPK", "modified", "title", "uid", "userName"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws PortalException {
        return this._kbArticleModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
            this.addSearchTerm(searchQuery, searchContext, "content", true);
            this.addSearchTerm(searchQuery, searchContext, "description", true);
            this.addSearchTerm(searchQuery, searchContext, "title", true);
            this.addSearchTerm(searchQuery, searchContext, "userName", true);
            return;
        }
        BooleanQueryImpl keywordsBooleanQuery = new BooleanQueryImpl();
        this.addSearchTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "content", true);
        this.addSearchTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "description", true);
        this.addSearchTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "title", true);
        this.addSearchTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "userName", true);
        if (!keywordsBooleanQuery.hasClauses()) {
            return;
        }
        try {
            BooleanQueryImpl modelBooleanQuery = new BooleanQueryImpl();
            modelBooleanQuery.add((Query)new TermQueryImpl("entryClassName", CLASS_NAME), BooleanClauseOccur.MUST);
            modelBooleanQuery.add((Query)keywordsBooleanQuery, BooleanClauseOccur.MUST);
            searchQuery.add((Query)modelBooleanQuery, BooleanClauseOccur.SHOULD);
        }
        catch (ParseException parseException) {
            throw new SystemException((Throwable)parseException);
        }
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        Hits hits = super.search(searchContext);
        String[] queryTerms = (String[])ArrayUtil.append((Object[])GetterUtil.getStringValues((String[])hits.getQueryTerms()), (Object[])KnowledgeBaseUtil.splitKeywords((String)searchContext.getKeywords()));
        hits.setQueryTerms(queryTerms);
        return hits;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ModelDocumentContributor.class, (String)"(indexer.class.name=com.liferay.knowledge.base.model.KBArticle)");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected void doDelete(KBArticle kbArticle) throws Exception {
        this.deleteDocument(kbArticle.getCompanyId(), kbArticle.getResourcePrimKey());
    }

    protected Document doGetDocument(KBArticle kbArticle) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)kbArticle);
        this._serviceTrackerList.forEach(modelDocumentContributor -> modelDocumentContributor.contribute(document, (BaseModel)kbArticle));
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String prefix = "snippet_";
        String title = document.get(prefix + "title", "title");
        String content = snippet;
        if (Validator.isNull((String)snippet) && Validator.isNull((String)(content = document.get(prefix + "description", "description")))) {
            content = document.get(prefix + "content", "content");
        }
        Summary summary = new Summary(title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(KBArticle kbArticle) throws Exception {
        this.indexWriterHelper.updateDocument(kbArticle.getCompanyId(), this.getDocument(kbArticle));
        this._reindexAttachments(kbArticle);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        KBArticle kbArticle = this.kbArticleLocalService.fetchLatestKBArticle(classPK, -1);
        if (kbArticle != null) {
            this._reindexKBArticles(kbArticle);
            return;
        }
        long kbArticleId = classPK;
        kbArticle = this.kbArticleLocalService.fetchKBArticle(kbArticleId);
        if (kbArticle != null) {
            this._reindexKBArticles(kbArticle);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexKBArticles(companyId);
    }

    private void _reindexAttachments(KBArticle kbArticle) throws Exception {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : kbArticle.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    private void _reindexKBArticles(KBArticle kbArticle) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (KBArticle curKBArticle : this.kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(kbArticle.getResourcePrimKey(), -1, null)) {
            documents.add(this.getDocument(curKBArticle));
        }
        for (KBArticle curKBArticle : this.kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(kbArticle.getResourcePrimKey(), 8, null)) {
            documents.add(this.getDocument(curKBArticle));
        }
        this.indexWriterHelper.updateDocuments(kbArticle.getCompanyId(), documents, this.isCommitImmediately());
    }

    private void _reindexKBArticles(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.kbArticleLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(property.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(kbArticle -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(kbArticle)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index knowledge base article " + kbArticle.getKbArticleId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

