/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.osgi.commands;

import com.liferay.osgi.util.osgi.commands.OSGiCommands;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.function=addImportArticlePermissions", "osgi.command.scope=knowledgeBase"}, service={OSGiCommands.class})
public class KnowledgeBaseOSGiCommands
implements OSGiCommands {
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    public void addImportArticlePermissions() throws PortalException {
        ResourceAction addKbArticleAction = this._getAddKbArticleAction();
        ResourceAction importKbArticlesAction = this._getImportKbArticlesAction();
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)"com.liferay.knowledge.base.admin")));
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            if (this._hasResourceAction((ResourcePermission)resourcePermission, addKbArticleAction)) {
                this._addResourceAction((ResourcePermission)resourcePermission, importKbArticlesAction);
            }
        });
        actionableDynamicQuery.performActions();
    }

    private void _addResourceAction(ResourcePermission permission, ResourceAction action) throws PortalException {
        permission.addResourceAction(action.getActionId());
        this._resourcePermissionLocalService.updateResourcePermission(permission);
    }

    private ResourceAction _getAddKbArticleAction() throws PortalException {
        return this._resourceActionLocalService.getResourceAction("com.liferay.knowledge.base.admin", "ADD_KB_ARTICLE");
    }

    private ResourceAction _getImportKbArticlesAction() throws PortalException {
        return this._resourceActionLocalService.getResourceAction("com.liferay.knowledge.base.admin", "IMPORT_KB_ARTICLES");
    }

    private boolean _hasResourceAction(ResourcePermission permission, ResourceAction action) {
        return this._resourcePermissionLocalService.hasActionId(permission, action);
    }
}

