/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer.util;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.internal.importer.util.KBArticleImporterUtil;
import com.liferay.knowledge.base.markdown.converter.MarkdownConverter;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class KBArticleMarkdownConverter {
    private static final String _METADATA_BASE_SOURCE_URL = "base.source.url";
    private static final Log _log = LogFactoryUtil.getLog(KBArticleMarkdownConverter.class);
    private final DLURLHelper _dlURLHelper;
    private final String _html;
    private final String _sourceURL;
    private final String _title;
    private final String _urlTitle;

    public KBArticleMarkdownConverter(String markdown, String fileEntryName, MarkdownConverter markdownConverter, Map<String, String> metadata, DLURLHelper dlURLHelper) throws KBArticleImportException {
        this._dlURLHelper = dlURLHelper;
        String html = null;
        try {
            html = markdownConverter.convert(markdown);
        }
        catch (IOException ioException) {
            throw new KBArticleImportException("Unable to convert Markdown to HTML: " + ioException.getLocalizedMessage(), (Throwable)ioException);
        }
        String heading = this._getHeading(html);
        if (Validator.isNull((String)heading)) {
            throw new KBArticleImportException("Unable to extract title heading from file: " + fileEntryName);
        }
        this._urlTitle = this.getUrlTitle(html);
        if (Validator.isNull((String)this._urlTitle)) {
            throw new KBArticleImportException("Missing title heading ID in file: " + fileEntryName);
        }
        String title = HtmlUtil.unescape((String)heading);
        int x = title.indexOf("[](id=");
        if (x != -1) {
            title = title.substring(0, x);
        }
        this._title = title;
        html = this._stripIds(html);
        this._html = this._stripHeading(html);
        String baseSourceURL = metadata.get(_METADATA_BASE_SOURCE_URL);
        this._sourceURL = this._buildSourceURL(baseSourceURL, fileEntryName);
    }

    public String getSourceURL() {
        return this._sourceURL;
    }

    public String getTitle() {
        return this._title;
    }

    public String getUrlTitle() {
        return this._urlTitle;
    }

    public String processAttachmentsReferences(long userId, KBArticle kbArticle, ZipReader zipReader, Map<String, FileEntry> fileEntriesMap) throws PortalException {
        int curIndex;
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        int index = 0;
        while ((index = this._html.indexOf("<img", index)) > -1) {
            indexes.add(index);
            index += 4;
        }
        if (indexes.isEmpty()) {
            return this._html;
        }
        StringBundler sb = new StringBundler();
        int previousIndex = 0;
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext() && (curIndex = ((Integer)iterator.next()).intValue()) >= 0) {
            int pos;
            if (curIndex > previousIndex) {
                String text = this._html.substring(previousIndex, curIndex);
                sb.append(text);
            }
            if ((pos = this._html.indexOf(">", curIndex)) < 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Expected close tag for image " + this._html.substring(curIndex)));
                }
                sb.append(this._html.substring(curIndex));
                previousIndex = curIndex;
                break;
            }
            String text = this._html.substring(curIndex, pos);
            String imageFileName = KBArticleImporterUtil.extractImageFileName(text);
            FileEntry imageFileEntry = KBArticleImporterUtil.addImageFileEntry(imageFileName, userId, kbArticle, zipReader, fileEntriesMap);
            if (imageFileEntry == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to find image source " + text));
                }
                sb.append("<img alt=\"missing image\" src=\"\" ");
            } else {
                String imageSrc;
                block12: {
                    imageSrc = "";
                    try {
                        imageSrc = this._dlURLHelper.getPreviewURL(imageFileEntry, imageFileEntry.getFileVersion(), null, "");
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)("Unable to obtain image URL from file entry " + imageFileEntry.getFileEntryId()), (Throwable)portalException);
                    }
                }
                sb.append("<img alt=\"");
                sb.append(HtmlUtil.escapeAttribute((String)imageFileEntry.getTitle()));
                sb.append("\" src=\"");
                sb.append(imageSrc);
                sb.append("\" ");
            }
            previousIndex = pos;
        }
        if (previousIndex < this._html.length()) {
            sb.append(this._html.substring(previousIndex));
        }
        return sb.toString();
    }

    protected String getUrlTitle(String heading) {
        int x = heading.indexOf("<h1 id=");
        if (x == -1) {
            return null;
        }
        char quote = heading.charAt(x += 7);
        Object urlTitle = null;
        int y = heading.indexOf(quote, x + 1);
        if (y > x + 1) {
            urlTitle = heading.substring(x + 1, y);
            urlTitle = StringUtil.replace((String)urlTitle, (char)' ', (char)'-');
            urlTitle = StringUtil.toLowerCase((String)urlTitle);
        }
        if (urlTitle == null) {
            return null;
        }
        if (!((String)urlTitle).startsWith("/")) {
            urlTitle = "/" + (String)urlTitle;
        }
        int urlTitleMaxLength = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        while (((String)urlTitle).length() > urlTitleMaxLength) {
            int pos = ((String)urlTitle).lastIndexOf("-");
            if (pos == -1) {
                urlTitle = ((String)urlTitle).substring(0, urlTitleMaxLength);
                continue;
            }
            urlTitle = ((String)urlTitle).substring(0, pos);
        }
        return urlTitle;
    }

    private String _buildSourceURL(String baseSourceURL, String fileEntryName) {
        char c;
        int pos;
        if (!Validator.isUrl((String)baseSourceURL)) {
            return null;
        }
        for (pos = baseSourceURL.length() - 1; pos >= 0 && (c = baseSourceURL.charAt(pos)) == '/'; --pos) {
        }
        StringBundler sb = new StringBundler(3);
        sb.append(baseSourceURL.substring(0, pos + 1));
        if (!fileEntryName.startsWith("/")) {
            sb.append("/");
        }
        sb.append(FileUtil.replaceSeparator((String)fileEntryName));
        return sb.toString();
    }

    private String _getHeading(String html) {
        int x = html.indexOf("<h1");
        int y = html.indexOf("</h1>", x);
        if ((x = html.indexOf(62, x + 3)) == -1 || y == -1 || x > y) {
            return null;
        }
        return html.substring(x + 1, y);
    }

    private String _stripHeading(String html) {
        int index = html.indexOf("</h1>");
        if (index == -1) {
            return html;
        }
        return html.substring(index + 5);
    }

    private String _stripIds(String content) {
        int index = content.indexOf("[](id=");
        if (index == -1) {
            return content;
        }
        StringBundler sb = new StringBundler();
        do {
            int x;
            int y;
            if ((y = content.indexOf(")", x = content.indexOf("=", index))) != -1) {
                int z = content.indexOf("</h", y);
                if (z != y + 1) {
                    sb.append(content.substring(0, y + 1));
                } else {
                    sb.append(StringUtil.trimTrailing((String)content.substring(0, index)));
                }
            } else {
                if (!_log.isWarnEnabled()) break;
                String msg = content.substring(index);
                int spaceIndex = content.indexOf(" ");
                if (spaceIndex != -1) {
                    msg = content.substring(index, spaceIndex);
                }
                _log.warn((Object)("Missing ')' for web content containing header id " + msg));
                break;
            }
            content = content.substring(y + 1);
        } while ((index = content.indexOf("[](id=")) != -1);
        sb.append(content);
        return sb.toString();
    }
}

