/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class KBFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<KBFolder> {
    public static final String[] CLASS_NAMES = new String[]{KBFolder.class.getName()};
    @Reference
    private KBFolderLocalService _kbFolderLocalService;

    public void deleteStagedModel(KBFolder kbFolder) throws PortalException {
        this._kbFolderLocalService.deleteKBFolder(kbFolder);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        KBFolder kbFolder = this._kbFolderLocalService.fetchKBFolderByUuidAndGroupId(uuid, groupId);
        if (kbFolder != null) {
            this.deleteStagedModel(kbFolder);
        }
    }

    public List<KBFolder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbFolderLocalService.getKBFoldersByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBFolder kbFolder) throws Exception {
        KBFolder parentKBFolder = kbFolder.getParentKBFolder();
        if (parentKBFolder != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbFolder, (StagedModel)parentKBFolder, (String)"parent");
        }
        Element kbFolderElement = portletDataContext.getExportDataElement((ClassedModel)kbFolder);
        portletDataContext.addClassedModel(kbFolderElement, ExportImportPathUtil.getModelPath((StagedModel)kbFolder), (ClassedModel)kbFolder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBFolder kbFolder) throws Exception {
        long userId = portletDataContext.getUserId(kbFolder.getUserUuid());
        Map kbFolderIds = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
        long parentFolderId = MapUtil.getLong((Map)kbFolderIds, (long)kbFolder.getParentKBFolderId(), (long)kbFolder.getParentKBFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbFolder);
        KBFolder importedKBFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            KBFolder existingKBFolder = this._kbFolderLocalService.fetchKBFolder(kbFolder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingKBFolder == null) {
                serviceContext.setUuid(kbFolder.getUuid());
                importedKBFolder = this._kbFolderLocalService.addKBFolder(kbFolder.getExternalReferenceCode(), userId, portletDataContext.getScopeGroupId(), kbFolder.getClassNameId(), parentFolderId, kbFolder.getName(), kbFolder.getDescription(), serviceContext);
            } else {
                importedKBFolder = this._kbFolderLocalService.updateKBFolder(kbFolder.getClassNameId(), parentFolderId, existingKBFolder.getKbFolderId(), kbFolder.getName(), kbFolder.getDescription(), serviceContext);
            }
        } else {
            importedKBFolder = this._kbFolderLocalService.addKBFolder(kbFolder.getExternalReferenceCode(), userId, portletDataContext.getScopeGroupId(), kbFolder.getClassNameId(), parentFolderId, kbFolder.getName(), kbFolder.getDescription(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)kbFolder, (ClassedModel)importedKBFolder);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, KBFolder kbFolder) throws Exception {
        KBFolder existingKBFolder = (KBFolder)this.fetchStagedModelByUuidAndGroupId(kbFolder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingKBFolder == null || !existingKBFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)KBArticle.class.getName());
        if (trashHandler.isRestorable(existingKBFolder.getKbFolderId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(kbFolder.getUserUuid()), existingKBFolder.getKbFolderId());
        }
    }
}

