/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.base.KBFolderServiceBaseImpl;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class KBFolderServiceImpl
extends KBFolderServiceBaseImpl {
    private static volatile ModelResourcePermission<KBFolder> _kbFolderModelResourcePermission = ModelResourcePermissionFactory.getInstance(KBFolderServiceImpl.class, (String)"_kbFolderModelResourcePermission", KBFolder.class);

    public KBFolder addKBFolder(long groupId, long parentResourceClassNameId, long parentResourcePrimKey, String name, String description, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(_kbFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentResourcePrimKey, (String)"ADD_KB_FOLDER");
        return this.kbFolderLocalService.addKBFolder(this.getUserId(), groupId, parentResourceClassNameId, parentResourcePrimKey, name, description, serviceContext);
    }

    public KBFolder deleteKBFolder(long kbFolderId) throws PortalException {
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), kbFolderId, "DELETE");
        return this.kbFolderLocalService.deleteKBFolder(kbFolderId);
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId) throws PortalException {
        return this.fetchFirstChildKBFolder(groupId, kbFolderId, null);
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId, OrderByComparator<KBFolder> obc) throws PortalException {
        List kbFolders = this.kbFolderPersistence.filterFindByG_P(groupId, kbFolderId, 0, 1, obc);
        if (kbFolders.isEmpty()) {
            return null;
        }
        return (KBFolder)kbFolders.get(0);
    }

    public KBFolder fetchKBFolder(long kbFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.fetchKBFolder(kbFolderId);
        if (kbFolder != null) {
            _kbFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbFolder, "VIEW");
        }
        return kbFolder;
    }

    public KBFolder fetchKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.fetchKBFolderByUrlTitle(groupId, parentKbFolderId, urlTitle);
        if (kbFolder == null) {
            return null;
        }
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbFolder, "VIEW");
        return kbFolder;
    }

    public KBFolder getKBFolder(long kbFolderId) throws PortalException {
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), kbFolderId, "VIEW");
        return this.kbFolderLocalService.getKBFolder(kbFolderId);
    }

    public KBFolder getKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolderByUrlTitle(groupId, parentKbFolderId, urlTitle);
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbFolder, "VIEW");
        return kbFolder;
    }

    public List<KBFolder> getKBFolders(long groupId, long parentKBFolderId, int start, int end) throws PortalException {
        return this.kbFolderPersistence.filterFindByG_P(groupId, parentKBFolderId, start, end);
    }

    public List<Object> getKBFoldersAndKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.kbFolderFinder.filterFindF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersAndKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.kbFolderFinder.filterCountF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersCount(long groupId, long parentKBFolderId) throws PortalException {
        return this.kbFolderPersistence.filterCountByG_P(groupId, parentKBFolderId);
    }

    public void moveKBFolder(long kbFolderId, long parentKBFolderId) throws PortalException {
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), kbFolderId, "MOVE_KB_FOLDER");
        this.kbFolderLocalService.moveKBFolder(kbFolderId, parentKBFolderId);
    }

    @Deprecated
    public KBFolder updateKBFolder(long parentResourceClassNameId, long parentResourcePrimKey, long kbFolderId, String name, String description) throws PortalException {
        return this.updateKBFolder(parentResourceClassNameId, parentResourcePrimKey, kbFolderId, name, description, new ServiceContext());
    }

    public KBFolder updateKBFolder(long parentResourceClassNameId, long parentResourcePrimKey, long kbFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        _kbFolderModelResourcePermission.check(this.getPermissionChecker(), kbFolderId, "UPDATE");
        return this.kbFolderLocalService.updateKBFolder(parentResourceClassNameId, parentResourcePrimKey, kbFolderId, name, description, serviceContext);
    }
}

