/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class WriteLanguageBatchEngineDataTask
extends DefaultTask {
    private final ObjectMapper _objectMapper = new ObjectMapper();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLanguageFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", project.getProjectDir());
        args.put("include", "Language_*.properties");
        return project.fileTree(args);
    }

    @OutputFile
    public File getOutputFile() {
        Project project = this.getProject();
        return new File(project.getBuildDir(), "language.batch-engine-data.json");
    }

    @TaskAction
    public void writeLanguageBatchEngineData() throws IOException {
        JsonNode rootJsonNode = this._objectMapper.readTree(WriteLanguageBatchEngineDataTask.class.getResourceAsStream("dependencies/templates/language/language.batch-engine-data.json"));
        ArrayNode arrayNode = (ArrayNode)rootJsonNode.get("items");
        FileCollection languageFiles = this.getLanguageFiles();
        for (File file : languageFiles.getFiles()) {
            String fileName = file.getName();
            String languageId = fileName.substring("Language_".length(), fileName.lastIndexOf(".properties"));
            Properties properties = new Properties();
            properties.load(Files.newBufferedReader(file.toPath()));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                if (value.endsWith("(Automatic Copy)")) continue;
                ObjectNode objectNode = this._objectMapper.createObjectNode();
                objectNode.put("key", (String)entry.getKey());
                objectNode.put("languageId", languageId);
                objectNode.put("value", value);
                arrayNode.add((JsonNode)objectNode);
            }
        }
        File outputFile = this.getOutputFile();
        ObjectWriter objectWriter = this._objectMapper.writer();
        Files.write(outputFile.toPath(), objectWriter.writeValueAsBytes((Object)rootJsonNode), new OpenOption[0]);
    }
}

