/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.tasks.TaskContainer;

public class LiferayJspCompatibilityPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.withPlugin("com.liferay.jasper.jspc", plugin -> {
            this._configureCompileJspClasspathConfiguration(project);
            this._configureJspCConfiguration(project);
        });
    }

    private void _configureCompileJspClasspathConfiguration(Project project) {
        Configuration compileJspClasspathConfiguration = GradleUtil.addConfiguration((Project)project, (String)"compileJspClasspath");
        String configurationName = compileJspClasspathConfiguration.getName();
        ClassLoader classLoader = Project.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            GradleUtil.addDependency((Project)project, (String)configurationName, (FileCollection)project.files((Object[])urlClassLoader.getURLs()));
        }
        GradleUtil.addDependency((Project)project, (String)configurationName, (String)"org.apache.tomcat", (String)"tomcat-jasper", (String)"9.0.104");
        GradleUtil.addDependency((Project)project, (String)configurationName, (String)"com.liferay", (String)"com.liferay.gradle.plugins.jasper.jspc", (String)"3.0.0", (boolean)false);
        TaskContainer tasks = project.getTasks();
        tasks.withType(CompileJSPTask.class, compileJSP -> compileJSP.setCompileJspClasspath((FileCollection)GradleUtil.getConfiguration((Project)project, (String)configurationName)));
    }

    private void _configureJspCConfiguration(Project project) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"jspC");
        configuration.exclude(this._getExcludeMap("jakarta.servlet.jsp.jstl", "jakarta.servlet.jsp.jstl-api"));
        configuration.exclude(this._getExcludeMap("org.glassfish.web", "jakarta.servlet.jsp.jstl"));
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        resolutionStrategy.force(new Object[]{"org.apache.tomcat:tomcat-jasper:9.0.104"});
        GradleUtil.addDependency((Project)project, (String)"jspC", (String)"javax.servlet.jsp.jstl", (String)"javax.servlet.jsp.jstl-api", (String)"1.2.1");
        GradleUtil.addDependency((Project)project, (String)"jspC", (String)"org.glassfish.web", (String)"javax.servlet.jsp.jstl", (String)"1.2.3", (boolean)false);
    }

    private Map<String, String> _getExcludeMap(final String group, final String module) {
        return new HashMap<String, String>(){
            {
                this.put("group", group);
                this.put("module", module);
            }
        };
    }
}

