/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.util.Validator;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class VerifyProductTask
extends DefaultTask {
    private WorkspaceExtension _extension;
    private String _product;

    @Input
    @Optional
    public WorkspaceExtension getExtension() {
        return this._extension;
    }

    @Input
    @Optional
    public String getProduct() {
        return this._product;
    }

    public void setExtension(WorkspaceExtension extension) {
        this._extension = extension;
    }

    public void setProduct(String product) {
        this._product = product;
    }

    @TaskAction
    public void verifyProduct() throws Exception {
        if (Validator.isNull((String)this._extension.getAppServerTomcatVersion())) {
            throw new GradleException("Unable to get Tomcat version for product '" + this._product + "'");
        }
        if (Validator.isNull((String)this._extension.getBundleChecksumSHA512())) {
            throw new GradleException("Unable to get bundle checksum SHA-512 for product '" + this._product + "'");
        }
        if (Validator.isNull((String)this._extension.getBundleUrl())) {
            throw new GradleException("Unable to get bundle URL for product '" + this._product + "'");
        }
        if (Validator.isNull((String)this._extension.getDockerImageLiferay())) {
            throw new GradleException("Unable to get Liferay Docker image for product '" + this._product + "'");
        }
        if (Validator.isNull((String)this._extension.getTargetPlatformVersion())) {
            throw new GradleException("Unable to get target platform version for product '" + this._product + "'");
        }
    }
}

