/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.dxp.override.internal;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;

public abstract class BaseThemeFragmentBundleInstaller {
    private static final Log _log = LogFactoryUtil.getLog(BaseThemeFragmentBundleInstaller.class);

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        final Bundle fragmentBundle = this._getOrCreateFragmentBundle(bundleContext);
        Bundle systemBundle = bundleContext.getBundle(0L);
        final BundleContext systemBundleContext = systemBundle.getBundleContext();
        final Bundle currentBundle = bundleContext.getBundle();
        systemBundleContext.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                Bundle bundle = bundleEvent.getBundle();
                if (!bundle.equals(currentBundle)) {
                    return;
                }
                if (bundleEvent.getType() == 2) {
                    systemBundleContext.removeBundleListener((BundleListener)this);
                    return;
                }
                if (bundleEvent.getType() != 16) {
                    return;
                }
                try {
                    fragmentBundle.uninstall();
                }
                catch (BundleException bundleException) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to uninstall fragment bundle ", fragmentBundle, " for host bundle ", BaseThemeFragmentBundleInstaller.this.getHostBundleSymbolicName()}), (Throwable)bundleException);
                }
                systemBundleContext.removeBundleListener((BundleListener)this);
            }
        });
    }

    protected abstract String getHostBundleSymbolicName();

    protected abstract String[] getResources();

    private InputStream _generateBundleContent() throws Exception {
        String hostBundleSymbolicName = this.getHostBundleSymbolicName();
        Class<?> clazz = this.getClass();
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        Version version = bundle.getVersion();
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue("Bundle-ManifestVersion", "2");
                attributes.putValue("Bundle-SymbolicName", hostBundleSymbolicName.concat("-fragment"));
                attributes.putValue("Bundle-Version", version.toString());
                attributes.putValue("Fragment-Host", hostBundleSymbolicName);
                attributes.putValue("Manifest-Version", "2");
                jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(jarOutputStream);
                jarOutputStream.closeEntry();
                for (String resource : this.getResources()) {
                    jarOutputStream.putNextEntry(new ZipEntry("images/".concat(resource)));
                    StreamUtil.transfer((InputStream)clazz.getResourceAsStream(resource), (OutputStream)jarOutputStream, (boolean)false);
                    jarOutputStream.closeEntry();
                }
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    private Bundle _getOrCreateFragmentBundle(BundleContext bundleContext) throws Exception {
        String location = "theme-fragment:" + this.getHostBundleSymbolicName();
        Bundle fragmentBundle = bundleContext.getBundle(location);
        if (fragmentBundle == null) {
            fragmentBundle = bundleContext.installBundle(location, this._generateBundleContent());
        }
        return fragmentBundle;
    }
}

