/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm.model;

import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JSPackageAdapter
implements JSPackage {
    private final String _id;
    private final JSBundle _jsBundle;
    private final List<JSModuleAlias> _jsModuleAliases = new ArrayList<JSModuleAlias>();
    private final List<JSModule> _jsModules = new ArrayList<JSModule>();
    private final Map<String, JSPackageDependency> _jsPackageDependencies = new HashMap<String, JSPackageDependency>();
    private final String _mainModuleName;
    private final String _name;
    private final String _resolvedId;
    private final String _version;

    public JSPackageAdapter(JSBundle jsBundle, String name, String version, String mainModuleName) {
        this._jsBundle = jsBundle;
        this._name = name;
        this._version = version;
        this._mainModuleName = mainModuleName;
        this._resolvedId = name + "@" + version;
        this._id = jsBundle.getId() + "/" + this._resolvedId;
    }

    public void addJSModule(JSModule jsModule) {
        this._jsModules.add(jsModule);
    }

    public void addJSModuleAlias(JSModuleAlias jsModuleAlias) {
        this._jsModuleAliases.add(jsModuleAlias);
    }

    public void addJSPackageDependency(JSPackageDependency jsPackageDependency) {
        this._jsPackageDependencies.put(jsPackageDependency.getPackageName(), jsPackageDependency);
    }

    public String getId() {
        return this._id;
    }

    public JSBundle getJSBundle() {
        return this._jsBundle;
    }

    public Collection<JSModuleAlias> getJSModuleAliases() {
        return this._jsModuleAliases;
    }

    public Collection<JSModule> getJSModules() {
        return this._jsModules;
    }

    public Collection<JSPackageDependency> getJSPackageDependencies() {
        return this._jsPackageDependencies.values();
    }

    public JSPackageDependency getJSPackageDependency(String packageName) {
        return this._jsPackageDependencies.get(packageName);
    }

    public String getMainModuleName() {
        return this._mainModuleName;
    }

    public String getName() {
        return this._name;
    }

    public String getResolvedId() {
        return this._resolvedId;
    }

    public String getVersion() {
        return this._version;
    }
}

