/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm.model;

import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class JSModuleAdapter
implements JSModule {
    private final Collection<String> _dependencies;
    private final List<String> _dependencyPackageNames = new ArrayList<String>();
    private final String _id;
    private final JSPackage _jsPackage;
    private final String _name;
    private final String _resolvedId;
    private final String _resolvedURL;
    private final String _url;

    public JSModuleAdapter(JSPackage jsPackage, String name, String url, String resolvedURL, String resolvedId, Collection<String> dependencies) {
        this._jsPackage = jsPackage;
        this._name = name;
        this._url = url;
        this._resolvedURL = resolvedURL;
        this._resolvedId = resolvedId;
        this._dependencies = dependencies;
        this._id = ModuleNameUtil.getModuleId((JSPackage)jsPackage, (String)name);
        for (String dependency : dependencies) {
            String packageName = ModuleNameUtil.getPackageName((String)dependency);
            if (packageName == null) continue;
            this._dependencyPackageNames.add(packageName);
        }
    }

    public Collection<String> getDependencies() {
        return this._dependencies;
    }

    public Collection<String> getDependencyPackageNames() {
        return this._dependencyPackageNames;
    }

    public String getId() {
        return this._id;
    }

    public JSPackage getJSPackage() {
        return this._jsPackage;
    }

    public String getName() {
        return this._name;
    }

    public String getResolvedId() {
        return this._resolvedId;
    }

    public String getResolvedURL() {
        return this._resolvedURL;
    }

    public String getURL() {
        return this._url;
    }
}

