/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.rest.internal.resource.v1_0;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.report.model.ExportImportReportEntry;
import com.liferay.exportimport.report.service.ExportImportReportEntryLocalService;
import com.liferay.exportimport.rest.dto.v1_0.Origin;
import com.liferay.exportimport.rest.dto.v1_0.ReportEntry;
import com.liferay.exportimport.rest.dto.v1_0.Scope;
import com.liferay.exportimport.rest.dto.v1_0.Status;
import com.liferay.exportimport.rest.dto.v1_0.Type;
import com.liferay.exportimport.rest.internal.odata.entity.v1_0.ReportEntryEntityModel;
import com.liferay.exportimport.rest.internal.resource.v1_0.BaseReportEntryResourceImpl;
import com.liferay.exportimport.rest.internal.util.PermissionUtil;
import com.liferay.exportimport.rest.resource.v1_0.ReportEntryResource;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/report-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={ReportEntryResource.class})
public class ReportEntryResourceImpl
extends BaseReportEntryResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(ReportEntryResourceImpl.class);
    private static final EntityModel _entityModel = new ReportEntryEntityModel();
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportReportEntryLocalService _exportImportReportEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<ReportEntry> getImportProcessReportEntriesPage(Long importProcessId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(importProcessId.longValue());
        PermissionUtil.checkPermission(this.contextCompany.getCompanyId(), backgroundTask.getGroupId());
        Map taskContextMap = backgroundTask.getTaskContextMap();
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("exportImportConfigurationId_long", MapUtil.getString((Map)taskContextMap, (Object)"exportImportConfigurationId")), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)ExportImportReportEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toReportEntry(this._exportImportReportEntryLocalService.getExportImportReportEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public ReportEntry getReportEntry(Long reportEntryId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        ExportImportReportEntry exportImportReportEntry = this._exportImportReportEntryLocalService.getExportImportReportEntry(reportEntryId.longValue());
        PermissionUtil.checkPermission(this.contextCompany.getCompanyId(), exportImportReportEntry.getGroupId());
        return this._toReportEntry(exportImportReportEntry);
    }

    private String _getErrorStacktrace(ExportImportReportEntry exportImportReportEntry) {
        MultivaluedMap queryParameters = this.contextUriInfo.getQueryParameters();
        String nestedFields = (String)queryParameters.getFirst((Object)"nestedFields");
        if (nestedFields == null || !nestedFields.contains("errorStacktrace")) {
            return null;
        }
        return exportImportReportEntry.getErrorStacktrace();
    }

    private String _getOriginLabel(int origin) {
        if (origin == 1) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "batch");
        }
        if (origin == 2) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "staging");
        }
        return null;
    }

    private Scope _getScope(final ExportImportReportEntry exportImportReportEntry) {
        return new Scope(){
            {
                this.setKey(() -> ((ExportImportReportEntry)exportImportReportEntry).getScopeKey());
                this.setLabel(() -> ReportEntryResourceImpl.this._getScopeLabel(exportImportReportEntry));
                this.setType(() -> ((ExportImportReportEntry)exportImportReportEntry).getScope());
            }
        };
    }

    private String _getScopeLabel(ExportImportReportEntry exportImportReportEntry) {
        try {
            if (StringUtil.equals((String)exportImportReportEntry.getScope(), (String)"company")) {
                Company company = this._companyLocalService.getCompany(exportImportReportEntry.getCompanyId());
                return company.getName();
            }
            Group group = this._groupLocalService.fetchGroup(GroupUtil.getGroupId((long)this.contextCompany.getCompanyId(), (String)exportImportReportEntry.getScopeKey(), (GroupLocalService)this._groupLocalService).longValue());
            if (group != null) {
                return group.getDescriptiveName(this.contextAcceptLanguage.getPreferredLocale());
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return null;
    }

    private String _getStatusLabel(int status) {
        if (status == 1) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "resolved");
        }
        if (status == 2) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "not-resolved");
        }
        return null;
    }

    private String _getTypeLabel(int type) {
        if (type == 2) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "empty");
        }
        if (type == 1) {
            return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), "error");
        }
        return null;
    }

    private String _toModelName(String modelName) {
        String value;
        String modelResourceKey = "model.resource." + modelName;
        if (!StringUtil.equals((String)modelResourceKey, (String)(value = this._language.get(this.contextAcceptLanguage.getPreferredLocale(), modelResourceKey)))) {
            return value;
        }
        return this._language.get(this.contextAcceptLanguage.getPreferredLocale(), modelName);
    }

    private Origin _toOrigin(final int origin) {
        return new Origin(){
            {
                this.setCode(() -> origin);
                this.setLabel(() -> ReportEntryResourceImpl.this._getOriginLabel(origin));
            }
        };
    }

    private ReportEntry _toReportEntry(final ExportImportReportEntry exportImportReportEntry) throws PortalException {
        final ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportReportEntry.getExportImportConfigurationId());
        return new ReportEntry(){
            {
                this.setClassExternalReferenceCode(() -> ((ExportImportReportEntry)exportImportReportEntry).getClassExternalReferenceCode());
                this.setClassPK(() -> ((ExportImportReportEntry)exportImportReportEntry).getClassPK());
                this.setConfigurationId(() -> ((ExportImportReportEntry)exportImportReportEntry).getExportImportConfigurationId());
                this.setCreator(() -> CreatorUtil.toCreator(null, (Portal)ReportEntryResourceImpl.this._portal, (User)ReportEntryResourceImpl.this._userLocalService.fetchUser(exportImportConfiguration.getUserId())));
                this.setDateCreated(() -> ((ExportImportReportEntry)exportImportReportEntry).getCreateDate());
                this.setDateModified(() -> ((ExportImportReportEntry)exportImportReportEntry).getModifiedDate());
                this.setErrorMessage(() -> ((ExportImportReportEntry)exportImportReportEntry).getErrorMessage());
                this.setErrorStacktrace(() -> ReportEntryResourceImpl.this._getErrorStacktrace(exportImportReportEntry));
                this.setId(() -> ((ExportImportReportEntry)exportImportReportEntry).getExportImportReportEntryId());
                this.setModelName(() -> ReportEntryResourceImpl.this._toModelName(exportImportReportEntry.getModelName()));
                this.setOrigin(() -> ReportEntryResourceImpl.this._toOrigin(exportImportReportEntry.getOrigin()));
                this.setScope(() -> ReportEntryResourceImpl.this._getScope(exportImportReportEntry));
                this.setStatus(() -> ReportEntryResourceImpl.this._toStatus(exportImportReportEntry.getStatus()));
                this.setType(() -> ReportEntryResourceImpl.this._toType(exportImportReportEntry.getType()));
            }
        };
    }

    private Status _toStatus(final int status) {
        return new Status(){
            {
                this.setCode(() -> status);
                this.setLabel(() -> ReportEntryResourceImpl.this._language.get(ReportEntryResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), ReportEntryResourceImpl.this._getStatusLabel(status)));
            }
        };
    }

    private Type _toType(final int type) {
        return new Type(){
            {
                this.setCode(() -> type);
                this.setLabel(() -> ReportEntryResourceImpl.this._language.get(ReportEntryResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), ReportEntryResourceImpl.this._getTypeLabel(type)));
            }
        };
    }
}

