/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplateLink;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateLinkLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplateLink"}, service={AopService.class})
public class DDMTemplateLinkLocalServiceImpl
extends DDMTemplateLinkLocalServiceBaseImpl {
    public DDMTemplateLink addTemplateLink(long classNameId, long classPK, long templateId) {
        long templateLinkId = this.counterLocalService.increment();
        DDMTemplateLink templateLink = this.ddmTemplateLinkPersistence.create(templateLinkId);
        templateLink.setClassNameId(classNameId);
        templateLink.setClassPK(classPK);
        templateLink.setTemplateId(templateId);
        return (DDMTemplateLink)this.ddmTemplateLinkPersistence.update((BaseModel)templateLink);
    }

    public DDMTemplateLink deleteTemplateLink(DDMTemplateLink templateLink) {
        return (DDMTemplateLink)this.ddmTemplateLinkPersistence.remove((BaseModel)templateLink);
    }

    public DDMTemplateLink deleteTemplateLink(long templateLinkId) throws PortalException {
        DDMTemplateLink templateLink = this.ddmTemplateLinkPersistence.findByPrimaryKey(templateLinkId);
        return this.deleteDDMTemplateLink(templateLink);
    }

    public DDMTemplateLink deleteTemplateLink(long classNameId, long classPK) {
        DDMTemplateLink templateLink = this.ddmTemplateLinkPersistence.fetchByC_C(classNameId, classPK);
        if (templateLink != null) {
            this.deleteDDMTemplateLink(templateLink);
        }
        return templateLink;
    }

    public void deleteTemplateLinks(long templateId) {
        this.ddmTemplateLinkPersistence.removeByTemplateId(templateId);
    }

    public DDMTemplateLink getTemplateLink(long templateLinkId) throws PortalException {
        return this.ddmTemplateLinkPersistence.findByPrimaryKey(templateLinkId);
    }

    public DDMTemplateLink getTemplateLink(long classNameId, long classPK) throws PortalException {
        return this.ddmTemplateLinkPersistence.findByC_C(classNameId, classPK);
    }

    @Deprecated
    public List<DDMTemplateLink> getTemplateLinks(long classNameId) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        return this.dynamicQuery(dynamicQuery);
    }

    public List<DDMTemplateLink> getTemplateLinksByTemplateId(long templateId) {
        return this.ddmTemplateLinkPersistence.findByTemplateId(templateId);
    }

    public DDMTemplateLink updateTemplateLink(long templateLinkId, long templateId) throws PortalException {
        DDMTemplateLink templateLink = this.ddmTemplateLinkPersistence.findByPrimaryKey(templateLinkId);
        templateLink.setTemplateId(templateId);
        return (DDMTemplateLink)this.ddmTemplateLinkPersistence.update((BaseModel)templateLink);
    }

    public DDMTemplateLink updateTemplateLink(long classNameId, long classPK, long templateId) {
        DDMTemplateLink templateLink = this.ddmTemplateLinkPersistence.fetchByC_C(classNameId, classPK);
        if (templateLink == null) {
            return this.addTemplateLink(classNameId, classPK, templateId);
        }
        templateLink.setTemplateId(templateId);
        return (DDMTemplateLink)this.ddmTemplateLinkPersistence.update((BaseModel)templateLink);
    }
}

