/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_3_1;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DL_FILE_ENTRY_METADATA = "com.liferay.document.library.kernel.model.DLFileEntryMetadata";
    private static final String _CLASS_NAME_JOURNAL_ARTICLE = "com.liferay.journal.model.JournalArticle";
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private final Language _language;

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer, Language language) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._language = language;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructure();
        this._upgradeDDMStructureVersion();
    }

    private void _addLabelToFieldsGroup(final Set<Locale> availableLocales, List<DDMFormField> ddmFormFields) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (Objects.equals(ddmFormField.getType(), "fieldset") && !this._isLabelSet(ddmFormField)) {
                ddmFormField.setLabel(new LocalizedValue(){
                    {
                        for (Locale locale : availableLocales) {
                            this.addString(locale, DDMStructureUpgradeProcess.this._language.get(locale, "fields-group"));
                        }
                    }
                });
                ddmFormField.setLocalizable(true);
                ddmFormField.setProperty("labelAtStructureLevel", (Object)true);
                ddmFormField.setShowLabel(true);
            }
            if (!ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
            this._addLabelToFieldsGroup(availableLocales, ddmFormField.getNestedDDMFormFields());
        }
    }

    private String _addLabelToFieldsGroup(String dataDefinition) throws Exception {
        DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)dataDefinition);
        this._addLabelToFieldsGroup(ddmForm.getAvailableLocales(), ddmForm.getDDMFormFields());
        return DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
    }

    private boolean _isLabelSet(DDMFormField ddmFormField) {
        LocalizedValue localizedValue = ddmFormField.getLabel();
        Map values = localizedValue.getValues();
        for (String value : values.values()) {
            if (!Validator.isNotNull((String)value)) continue;
            return true;
        }
        return false;
    }

    private void _upgradeDDMStructure() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, structureId, definition from DDMStructure where classNameId = ? or classNameId = ? order by createDate");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where ctCollectionId = ? and structureId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            preparedStatement1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    preparedStatement2.setString(1, this._addLabelToFieldsGroup(resultSet.getString("definition")));
                    preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                    preparedStatement2.setLong(3, resultSet.getLong("structureId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureKey,  ", "DDMStructureVersion.ctCollectionId, ", "DDMStructureVersion.structureVersionId, ", "DDMStructureVersion.definition from DDMStructureVersion ", "inner join DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ? or DDMStructure.classNameId ", "= ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where ctCollectionId = ? and structureVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            preparedStatement1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    preparedStatement2.setString(1, this._addLabelToFieldsGroup(resultSet.getString("definition")));
                    preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                    preparedStatement2.setLong(3, resultSet.getLong("structureVersionId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

