/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureLayout"}, service={ModelDocumentContributor.class})
public class DDMStructureLayoutModelDocumentContributor
implements ModelDocumentContributor<DDMStructureLayout> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    private Localization _localization;

    public void contribute(Document document, DDMStructureLayout ddmStructureLayout) {
        document.addKeyword("classNameId", this.classNameLocalService.getClassNameId(DDMStructureLayout.class));
        document.addLocalizedText("description", this._localization.populateLocalizationMap(ddmStructureLayout.getDescriptionMap(), ddmStructureLayout.getDefaultLanguageId(), ddmStructureLayout.getGroupId()));
        document.addLocalizedText("name", this._localization.populateLocalizationMap(ddmStructureLayout.getNameMap(), ddmStructureLayout.getDefaultLanguageId(), ddmStructureLayout.getGroupId()));
        document.addLocalizedKeyword("localized_name", this._localization.populateLocalizationMap(ddmStructureLayout.getNameMap(), ddmStructureLayout.getDefaultLanguageId(), ddmStructureLayout.getGroupId()), true, true);
        document.addKeyword("structureVersionId", ddmStructureLayout.getStructureVersionId());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

