/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceRecordVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMFormInstanceRecordVersion"}, service={AopService.class})
public class DDMFormInstanceRecordVersionServiceImpl
extends DDMFormInstanceRecordVersionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private ModelResourcePermission<DDMFormInstanceRecord> _ddmFormInstanceRecordModelResourcePermission;

    public DDMFormInstanceRecordVersion fetchLatestFormInstanceRecordVersion(long userId, long formInstanceId, String formInstanceVersion, int status) throws PortalException {
        DDMFormInstanceRecordVersion latestFormInstanceRecordVersion = this.ddmFormInstanceRecordVersionLocalService.fetchLatestFormInstanceRecordVersion(userId, formInstanceId, formInstanceVersion, status);
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), latestFormInstanceRecordVersion.getFormInstanceRecordId(), "VIEW");
        return latestFormInstanceRecordVersion;
    }

    public DDMFormInstanceRecordVersion getFormInstanceRecordVersion(long ddmFormInstanceRecordVersionId) throws PortalException {
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(ddmFormInstanceRecordVersionId);
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordVersion.getFormInstanceRecordId(), "VIEW");
        return ddmFormInstanceRecordVersion;
    }

    public DDMFormInstanceRecordVersion getFormInstanceRecordVersion(long ddmFormInstanceRecordId, String version) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "VIEW");
        return this.ddmFormInstanceRecordVersionPersistence.findByF_V(ddmFormInstanceRecordId, version);
    }

    public List<DDMFormInstanceRecordVersion> getFormInstanceRecordVersions(long ddmFormInstanceRecordId) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "VIEW");
        return this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceRecordId);
    }

    public List<DDMFormInstanceRecordVersion> getFormInstanceRecordVersions(long ddmFormInstanceRecordId, int start, int end, OrderByComparator<DDMFormInstanceRecordVersion> orderByComparator) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "VIEW");
        return this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceRecordId, start, end, orderByComparator);
    }

    public int getFormInstanceRecordVersionsCount(long ddmFormInstanceRecordId) throws PortalException {
        this._ddmFormInstanceRecordModelResourcePermission.check(this.getPermissionChecker(), ddmFormInstanceRecordId, "VIEW");
        return this.ddmFormInstanceRecordVersionPersistence.countByFormInstanceRecordId(ddmFormInstanceRecordId);
    }
}

