/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class JournalArticleDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleDDMFormFieldValueRenderer.class);

    public String getSupportedDDMFormFieldType() {
        return "ddm-journal-article";
    }

    protected ValueAccessor getValueAccessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONObject jsonObject = this.createJSONObject(value.getString(this.locale));
                String className = jsonObject.getString("className");
                long classPK = jsonObject.getLong("classPK");
                if (Validator.isNull((String)className) && classPK == 0L) {
                    return "";
                }
                try {
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
                    return assetEntry.getTitle(this.locale);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    return LanguageUtil.format((Locale)this.locale, (String)"is-temporarily-unavailable", (Object)"content");
                }
            }

            protected JSONObject createJSONObject(String json) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)json);
                }
                catch (JSONException jsonException) {
                    throw new ValueAccessorException((Throwable)jsonException);
                }
            }
        };
    }
}

