/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.messaging;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/ddm_structure_reindex"}, service={MessageListener.class})
public class DDMStructureReindexMessageListener
extends BaseMessageListener {
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    protected void doReceive(Message message) throws Exception {
        DDMStructureIndexer ddmStructureIndexer = (DDMStructureIndexer)message.get("ddmStructureIndexer");
        long structureId = message.getLong("structureId");
        ArrayList<Long> ddmStructureIds = new ArrayList<Long>();
        ddmStructureIds.add(structureId);
        this._collectChildrenStructureIds(ddmStructureIds, structureId);
        ddmStructureIndexer.reindexDDMStructures(ddmStructureIds);
    }

    private void _collectChildrenStructureIds(List<Long> structureIds, long parentStructureId) {
        List structures = this._ddmStructureLocalService.getChildrenStructures(parentStructureId);
        for (DDMStructure structure : structures) {
            structureIds.add(structure.getStructureId());
            this._collectChildrenStructureIds(structureIds, structure.getStructureId());
        }
    }
}

