/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMField;
import com.liferay.dynamic.data.mapping.model.DDMFieldAttribute;
import com.liferay.dynamic.data.mapping.model.DDMFieldAttributeTable;
import com.liferay.dynamic.data.mapping.model.DDMFieldTable;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersionTable;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.base.DDMFieldLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFieldAttributePersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMField"}, service={AopService.class})
public class DDMFieldLocalServiceImpl
extends DDMFieldLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldLocalServiceImpl.class);
    @Reference
    private DDMFieldAttributePersistence _ddmFieldAttributePersistence;
    @Reference
    private DDMStructurePersistence _ddmStructurePersistence;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public void deleteDDMFields(long structureId) {
        for (DDMFieldAttribute ddmFieldAttribute : (List)this._ddmFieldAttributePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)DDMFieldAttributeTable.INSTANCE).from((Table)DDMFieldAttributeTable.INSTANCE).innerJoinON((Table)DDMFieldTable.INSTANCE, DDMFieldTable.INSTANCE.fieldId.eq((Expression)DDMFieldAttributeTable.INSTANCE.fieldId)).innerJoinON((Table)DDMStructureVersionTable.INSTANCE, DDMStructureVersionTable.INSTANCE.structureVersionId.eq((Expression)DDMFieldTable.INSTANCE.structureVersionId).and((Expression)DDMStructureVersionTable.INSTANCE.structureId.eq((Object)structureId))))) {
            this._ddmFieldAttributePersistence.remove((BaseModel)ddmFieldAttribute);
        }
        for (DDMField ddmField : (List)this.ddmFieldPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)DDMFieldTable.INSTANCE).from((Table)DDMFieldTable.INSTANCE).innerJoinON((Table)DDMStructureVersionTable.INSTANCE, DDMStructureVersionTable.INSTANCE.structureVersionId.eq((Expression)DDMFieldTable.INSTANCE.structureVersionId).and((Expression)DDMStructureVersionTable.INSTANCE.structureId.eq((Object)structureId))))) {
            this.ddmFieldPersistence.remove((BaseModel)ddmField);
        }
    }

    public void deleteDDMFormValues(long storageId) {
        this.ddmFieldPersistence.removeByStorageId(storageId);
        this._ddmFieldAttributePersistence.removeByStorageId(storageId);
    }

    public DDMFieldAttribute fetchDDMFieldAttribute(long fieldId, String attributeName, String languageId) {
        return this._ddmFieldAttributePersistence.fetchByF_AN_L(fieldId, attributeName, languageId);
    }

    public List<DDMFieldAttribute> getDDMFieldAttributes(long storageId, String attributeName) {
        return this._ddmFieldAttributePersistence.findByS_AN(storageId, attributeName);
    }

    public List<DDMField> getDDMFields(long storageId, String fieldName) {
        return this.ddmFieldPersistence.findByS_F(storageId, fieldName);
    }

    public DDMFormValues getDDMFormValues(DDMForm ddmForm, long storageId) {
        List ddmFields = this.ddmFieldPersistence.findByStorageId(storageId);
        if (ddmFields.isEmpty()) {
            return null;
        }
        return this._getDDMFormValues(this._ddmFieldAttributePersistence.findByStorageId(storageId), ddmFields, ddmForm);
    }

    public DDMFormValues getDDMFormValues(DDMForm ddmForm, long storageId, String languageId) {
        List ddmFields;
        block4: {
            ddmFields = this.ddmFieldPersistence.findByStorageId(storageId);
            if (ddmFields.isEmpty()) {
                return null;
            }
            try {
                DDMFieldAttribute ddmFieldAttribute = this._ddmFieldAttributePersistence.findByS_AN_First(storageId, "availableLanguageIds", null);
                List availableLanguageIds = com.liferay.petra.string.StringUtil.split((String)ddmFieldAttribute.getAttributeValue());
                if (!availableLanguageIds.contains(languageId)) {
                    ddmFieldAttribute = this._ddmFieldAttributePersistence.findByS_AN_First(storageId, "defaultLanguageId", null);
                    languageId = ddmFieldAttribute.getAttributeValue();
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)portalException);
            }
        }
        return this._getDDMFormValues(this._ddmFieldAttributePersistence.findByS_L(storageId, new String[]{languageId, ""}), ddmFields, ddmForm);
    }

    public int getDDMFormValuesCount(long structureId) {
        return this.ddmFieldPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)DDMFieldTable.INSTANCE).innerJoinON((Table)DDMStructureVersionTable.INSTANCE, DDMStructureVersionTable.INSTANCE.structureVersionId.eq((Expression)DDMFieldTable.INSTANCE.structureVersionId).and((Expression)DDMStructureVersionTable.INSTANCE.structureId.eq((Object)structureId))));
    }

    public int getDDMFormValuesCount(long companyId, String fieldType, Map<String, Object> attributes) {
        JoinStep joinStep = DSLQueryFactoryUtil.count().from((Table)DDMFieldTable.INSTANCE);
        int aliasCount = 0;
        Column languageIdColumn = null;
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            DDMFieldAttributeTable aliasDDMFieldAttributeTable = (DDMFieldAttributeTable)DDMFieldAttributeTable.INSTANCE.as("aliasDDMFieldAttributeTable" + ++aliasCount);
            Predicate predicate = DDMFieldTable.INSTANCE.fieldId.eq((Expression)aliasDDMFieldAttributeTable.fieldId);
            if (languageIdColumn != null) {
                predicate = predicate.and((Expression)aliasDDMFieldAttributeTable.languageId.eq(languageIdColumn));
            }
            String key = entry.getKey();
            String value = null;
            if (key == null || key.isEmpty()) {
                predicate = predicate.and((Expression)aliasDDMFieldAttributeTable.attributeName.eq((Object)key).or((Expression)aliasDDMFieldAttributeTable.attributeName.isNull()).withParentheses());
                value = String.valueOf(entry.getValue());
            } else {
                predicate = predicate.and((Expression)aliasDDMFieldAttributeTable.attributeName.eq((Object)key));
                value = jsonSerializer.serialize(entry.getValue());
            }
            Column valueExpression = aliasDDMFieldAttributeTable.smallAttributeValue;
            if (value.length() > 255) {
                valueExpression = DSLFunctionFactoryUtil.castClobText((Expression)aliasDDMFieldAttributeTable.largeAttributeValue);
            }
            joinStep = joinStep.innerJoinON((Table)aliasDDMFieldAttributeTable, predicate.and((Expression)valueExpression.eq((Object)value)));
            languageIdColumn = aliasDDMFieldAttributeTable.languageId;
        }
        return this.ddmFieldPersistence.dslQueryCount((DSLQuery)joinStep.where(DDMFieldTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)DDMFieldTable.INSTANCE.fieldType.eq((Object)fieldType))));
    }

    public void updateDDMFormValues(long structureId, long storageId, DDMFormValues ddmFormValues) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructurePersistence.findByPrimaryKey(structureId);
        DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFieldInfo rootDDMFieldInfo = new DDMFieldInfo("", "", false, null);
        LinkedHashMap ddmFieldInfoMap = LinkedHashMapBuilder.put((Object)"", (Object)rootDDMFieldInfo).build();
        rootDDMFieldInfo._ddmFieldAttributeInfos.put("", Arrays.asList(new DDMFieldAttributeInfo("availableLanguageIds", com.liferay.petra.string.StringUtil.merge((Collection)ddmFormValues.getAvailableLocales(), LocaleUtil::toLanguageId, (String)","), rootDDMFieldInfo, ""), new DDMFieldAttributeInfo("defaultLanguageId", LocaleUtil.toLanguageId((Locale)ddmFormValues.getDefaultLocale()), rootDDMFieldInfo, "")));
        this._collectDDMFieldInfos(ddmFieldInfoMap, ddmFormFieldsMap, ddmFormValues.getDDMFormFieldValues(), null);
        DDMFormUpdateContext ddmFormUpdateContext = this._getDDMFormUpdateContext(ddmFieldInfoMap, ddmFormFieldsMap, storageId);
        long batchCounter = 0L;
        if (ddmFormUpdateContext._newDDMFieldsCount > 0) {
            batchCounter = this.counterLocalService.increment(DDMField.class.getName(), ddmFormUpdateContext._newDDMFieldsCount);
            batchCounter -= (long)ddmFormUpdateContext._newDDMFieldsCount;
        }
        int priority = 0;
        HashMap<String, Long> instanceToFieldIdMap = new HashMap<String, Long>();
        ArrayList<Map.Entry<DDMField, DDMFieldInfo>> childrenDDMFields = new ArrayList<Map.Entry<DDMField, DDMFieldInfo>>();
        ArrayList<Map.Entry<DDMField, DDMFieldInfo>> parentsDDMFields = new ArrayList<Map.Entry<DDMField, DDMFieldInfo>>();
        for (Map.Entry<DDMField, DDMFieldInfo> entry : ddmFormUpdateContext._ddmFieldEntries) {
            DDMFieldInfo ddmFieldInfo = entry.getValue();
            if (ddmFieldInfo == null || ddmFieldInfo._parentInstanceId == null) {
                parentsDDMFields.add(entry);
                continue;
            }
            childrenDDMFields.add(entry);
        }
        ddmFormUpdateContext._ddmFieldEntries.clear();
        ddmFormUpdateContext._ddmFieldEntries.addAll(parentsDDMFields);
        ddmFormUpdateContext._ddmFieldEntries.addAll(childrenDDMFields);
        for (Map.Entry<DDMField, DDMFieldInfo> entry : ddmFormUpdateContext._ddmFieldEntries) {
            DDMField ddmField = entry.getKey();
            DDMFieldInfo ddmFieldInfo = entry.getValue();
            if (ddmFieldInfo == null) {
                this.ddmFieldPersistence.remove((BaseModel)ddmField);
                continue;
            }
            if (ddmField == null) {
                ddmField = this.ddmFieldPersistence.create(++batchCounter);
            }
            long parentFieldId = 0L;
            if (ddmFieldInfo._parentInstanceId != null) {
                parentFieldId = (Long)instanceToFieldIdMap.get(ddmFieldInfo._parentInstanceId);
            }
            ddmField.setParentFieldId(parentFieldId);
            ddmField.setStorageId(storageId);
            ddmField.setStructureVersionId(ddmStructureVersion.getStructureVersionId());
            ddmField.setFieldName(ddmFieldInfo._fieldName);
            ddmField.setInstanceId(ddmFieldInfo._instanceId);
            ddmField.setPriority(priority);
            if (ddmFieldInfo != rootDDMFieldInfo) {
                DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(ddmFieldInfo._fieldName);
                ddmField.setFieldType(ddmFormField.getType());
                ddmField.setLocalizable(ddmFormField.isLocalizable());
            }
            ddmField = (DDMField)this.ddmFieldPersistence.update((BaseModel)ddmField);
            ++priority;
            instanceToFieldIdMap.put(ddmField.getInstanceId(), ddmField.getFieldId());
        }
        if (ddmFormUpdateContext._newDDMFieldAttributesCount > 0) {
            batchCounter = this.counterLocalService.increment(DDMFieldAttribute.class.getName(), ddmFormUpdateContext._newDDMFieldAttributesCount);
            batchCounter -= (long)ddmFormUpdateContext._newDDMFieldAttributesCount;
        }
        for (Map.Entry<Object, Object> entry : ddmFormUpdateContext._ddmFieldAttributeEntries) {
            DDMFieldAttribute ddmFieldAttribute = (DDMFieldAttribute)entry.getKey();
            DDMFieldAttributeInfo ddmFieldAttributeInfo = (DDMFieldAttributeInfo)entry.getValue();
            if (ddmFieldAttributeInfo == null) {
                this._ddmFieldAttributePersistence.remove((BaseModel)ddmFieldAttribute);
                continue;
            }
            if (ddmFieldAttribute == null) {
                ddmFieldAttribute = this._ddmFieldAttributePersistence.create(++batchCounter);
            }
            ddmFieldAttribute.setFieldId(((Long)instanceToFieldIdMap.get(ddmFieldAttributeInfo._ddmFieldInfo._instanceId)).longValue());
            ddmFieldAttribute.setStorageId(storageId);
            ddmFieldAttribute.setAttributeName(ddmFieldAttributeInfo._attributeName);
            ddmFieldAttribute.setLanguageId(ddmFieldAttributeInfo._languageId);
            ddmFieldAttribute.setAttributeValue(ddmFieldAttributeInfo._attributeValue);
            this._ddmFieldAttributePersistence.update((BaseModel)ddmFieldAttribute);
        }
    }

    private void _collectDDMFieldInfos(Map<String, DDMFieldInfo> ddmFieldInfoMap, Map<String, DDMFormField> ddmFormFieldMap, List<DDMFormFieldValue> ddmFormValues, String parentInstanceId) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues) {
            DDMFormField ddmFormField = ddmFormFieldMap.get(ddmFormFieldValue.getName());
            if (ddmFormField == null) continue;
            String instanceId = ddmFormFieldValue.getInstanceId();
            while (ddmFieldInfoMap.containsKey(instanceId)) {
                instanceId = StringUtil.randomString();
            }
            DDMFieldInfo ddmFieldInfo = new DDMFieldInfo(ddmFormFieldValue.getName(), instanceId, ddmFormField.isLocalizable(), parentInstanceId);
            ddmFieldInfoMap.put(instanceId, ddmFieldInfo);
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                Map values = value.getValues();
                for (Map.Entry entry : values.entrySet()) {
                    String languageId = this._language.getLanguageId((Locale)entry.getKey());
                    ddmFieldInfo._ddmFieldAttributeInfos.put(languageId, this._getDDMFieldAttributeInfos(ddmFieldInfo, languageId, (String)entry.getValue()));
                }
            }
            this._collectDDMFieldInfos(ddmFieldInfoMap, ddmFormFieldMap, ddmFormFieldValue.getNestedDDMFormFieldValues(), instanceId);
        }
    }

    private List<DDMFieldAttributeInfo> _getDDMFieldAttributeInfos(DDMFieldInfo ddmFieldInfo, String languageId, String valueString) {
        block5: {
            int length = valueString.length();
            if (length > 1 && valueString.charAt(0) == '{' && valueString.charAt(length - 1) == '}') {
                try {
                    JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
                    Set keySet = jsonObject.keySet();
                    if (!keySet.isEmpty()) {
                        ArrayList<DDMFieldAttributeInfo> ddmFieldAttributeInfos = new ArrayList<DDMFieldAttributeInfo>(keySet.size());
                        for (String key : jsonObject.keySet()) {
                            ddmFieldAttributeInfos.add(new DDMFieldAttributeInfo(key, jsonSerializer.serialize(jsonObject.get(key)), ddmFieldInfo, languageId));
                        }
                        return ddmFieldAttributeInfos;
                    }
                }
                catch (JSONException jsonException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to parse: " + valueString), (Throwable)jsonException);
                }
            }
        }
        return Collections.singletonList(new DDMFieldAttributeInfo("", valueString, ddmFieldInfo, languageId));
    }

    private DDMFormFieldValue _getDDMFormFieldValue(DDMFieldInfo ddmFieldInfo, Locale defaultLocale) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setInstanceId(ddmFieldInfo._instanceId);
        ddmFormFieldValue.setName(ddmFieldInfo._fieldName);
        if (ddmFieldInfo._localizable) {
            LocalizedValue value = new LocalizedValue(defaultLocale);
            for (Map.Entry<String, List<DDMFieldAttributeInfo>> entry : ddmFieldInfo._ddmFieldAttributeInfos.entrySet()) {
                Locale locale = LocaleUtil.fromLanguageId((String)entry.getKey(), (boolean)true, (boolean)false);
                if (locale == null) continue;
                value.addString(locale, this._getValueString(entry.getValue()));
            }
            ddmFormFieldValue.setValue((Value)value);
        } else {
            List<DDMFieldAttributeInfo> ddmFieldAttributeInfos = ddmFieldInfo._ddmFieldAttributeInfos.get("");
            if (ddmFieldAttributeInfos != null) {
                ddmFormFieldValue.setValue((Value)new UnlocalizedValue(this._getValueString(ddmFieldAttributeInfos)));
            }
        }
        for (DDMFieldInfo childDDMFieldInfo : ddmFieldInfo._childDDMFieldInfos) {
            ddmFormFieldValue.addNestedDDMFormFieldValue(this._getDDMFormFieldValue(childDDMFieldInfo, defaultLocale));
        }
        return ddmFormFieldValue;
    }

    private DDMFormUpdateContext _getDDMFormUpdateContext(Map<String, DDMFieldInfo> ddmFieldInfoMap, Map<String, DDMFormField> ddmFormFieldsMap, long storageId) {
        ArrayList<Map.Entry<DDMField, DDMFieldInfo>> ddmFieldEntries = new ArrayList<Map.Entry<DDMField, DDMFieldInfo>>();
        int newDDMFieldsCount = 0;
        HashMap ddmFieldsMap = new HashMap();
        ListUtil.isNotEmptyForEach((List)this.ddmFieldPersistence.findByStorageId(storageId), ddmField -> ddmFieldsMap.put(this._getKey(ddmField.getFieldName(), ddmField.getInstanceId()), ddmField));
        for (DDMFieldInfo ddmFieldInfo : ddmFieldInfoMap.values()) {
            String key = this._getKey(ddmFieldInfo._fieldName, ddmFieldInfo._instanceId);
            if (ddmFieldsMap.containsKey(key)) {
                ddmFieldEntries.add(new AbstractMap.SimpleImmutableEntry<DDMField, DDMFieldInfo>((DDMField)ddmFieldsMap.get(key), ddmFieldInfo));
                ddmFieldsMap.remove(key);
                continue;
            }
            ddmFieldEntries.add(new AbstractMap.SimpleImmutableEntry<Object, DDMFieldInfo>(null, ddmFieldInfo));
            ++newDDMFieldsCount;
        }
        for (DDMField ddmField2 : ddmFieldsMap.values()) {
            ddmFieldEntries.add(new AbstractMap.SimpleImmutableEntry<DDMField, Object>(ddmField2, null));
        }
        ArrayList<Map.Entry<DDMFieldAttribute, DDMFieldAttributeInfo>> ddmFieldAttributeEntries = new ArrayList<Map.Entry<DDMFieldAttribute, DDMFieldAttributeInfo>>();
        int newDDMFieldAttributesCount = 0;
        HashMap<Long, Map<String, DDMFieldAttribute>> ddmFieldsAttributesMap = new HashMap<Long, Map<String, DDMFieldAttribute>>();
        ListUtil.isNotEmptyForEach((List)this._ddmFieldAttributePersistence.findByStorageId(storageId), ddmFieldAttribute -> {
            HashMap<String, DDMFieldAttribute> ddmFieldAttributesMap = (HashMap<String, DDMFieldAttribute>)ddmFieldsAttributesMap.get(ddmFieldAttribute.getFieldId());
            if (ddmFieldAttributesMap == null) {
                ddmFieldAttributesMap = new HashMap<String, DDMFieldAttribute>();
                ddmFieldsAttributesMap.put(ddmFieldAttribute.getFieldId(), ddmFieldAttributesMap);
            }
            ddmFieldAttributesMap.put(this._getKey(ddmFieldAttribute.getAttributeName(), ddmFieldAttribute.getLanguageId()), (DDMFieldAttribute)ddmFieldAttribute);
        });
        for (Map.Entry entry : ddmFieldEntries) {
            DDMField ddmField3;
            DDMFieldInfo ddmFieldInfo = (DDMFieldInfo)entry.getValue();
            if (ddmFieldInfo == null || this._persistReadOnlyValues(ddmField3 = (DDMField)entry.getKey(), ddmFieldAttributeEntries, ddmFieldInfoMap, ddmFieldsAttributesMap, ddmFormFieldsMap)) continue;
            for (List<DDMFieldAttributeInfo> ddmFieldAttributeInfos : ddmFieldInfo._ddmFieldAttributeInfos.values()) {
                for (DDMFieldAttributeInfo ddmFieldAttributeInfo : ddmFieldAttributeInfos) {
                    String key;
                    Map ddmFieldAttributesMap;
                    if (ddmField3 != null && ddmFieldsAttributesMap.containsKey(ddmField3.getFieldId()) && (ddmFieldAttributesMap = (Map)ddmFieldsAttributesMap.get(ddmField3.getFieldId())).containsKey(key = this._getKey(ddmFieldAttributeInfo._attributeName, ddmFieldAttributeInfo._languageId))) {
                        ddmFieldAttributeEntries.add(new AbstractMap.SimpleImmutableEntry<DDMFieldAttribute, DDMFieldAttributeInfo>((DDMFieldAttribute)ddmFieldAttributesMap.get(key), ddmFieldAttributeInfo));
                        ddmFieldAttributesMap.remove(key);
                        if (!MapUtil.isEmpty((Map)ddmFieldAttributesMap)) continue;
                        ddmFieldsAttributesMap.remove(ddmField3.getFieldId());
                        continue;
                    }
                    ddmFieldAttributeEntries.add(new AbstractMap.SimpleImmutableEntry<Object, DDMFieldAttributeInfo>(null, ddmFieldAttributeInfo));
                    ++newDDMFieldAttributesCount;
                }
            }
        }
        for (Map map : ddmFieldsAttributesMap.values()) {
            for (DDMFieldAttribute ddmFieldAttribute2 : map.values()) {
                ddmFieldAttributeEntries.add(new AbstractMap.SimpleImmutableEntry<DDMFieldAttribute, Object>(ddmFieldAttribute2, null));
            }
        }
        return new DDMFormUpdateContext(ddmFieldAttributeEntries, ddmFieldEntries, newDDMFieldAttributesCount, newDDMFieldsCount);
    }

    private DDMFormValues _getDDMFormValues(List<DDMFieldAttribute> ddmFieldAttributes, List<DDMField> ddmFields, DDMForm ddmForm) {
        LinkedHashMap<Long, DDMFieldInfo> ddmFieldInfoMap = new LinkedHashMap<Long, DDMFieldInfo>();
        for (DDMField ddmField : ddmFields) {
            if (ddmField.getParentFieldId() == 0L) {
                ddmFieldInfoMap.put(ddmField.getFieldId(), new DDMFieldInfo(ddmField.getFieldName(), ddmField.getInstanceId(), ddmField.isLocalizable(), null));
                continue;
            }
            DDMFieldInfo parentDDMFieldInfo = (DDMFieldInfo)ddmFieldInfoMap.get(ddmField.getParentFieldId());
            DDMFieldInfo ddmFieldInfo = new DDMFieldInfo(ddmField.getFieldName(), ddmField.getInstanceId(), ddmField.isLocalizable(), parentDDMFieldInfo._instanceId);
            parentDDMFieldInfo._childDDMFieldInfos.add(ddmFieldInfo);
            ddmFieldInfoMap.put(ddmField.getFieldId(), ddmFieldInfo);
        }
        for (DDMFieldAttribute ddmFieldAttribute : ddmFieldAttributes) {
            DDMFieldInfo ddmFieldInfo = (DDMFieldInfo)ddmFieldInfoMap.get(ddmFieldAttribute.getFieldId());
            List ddmFieldAttributeInfos = ddmFieldInfo._ddmFieldAttributeInfos.computeIfAbsent(ddmFieldAttribute.getLanguageId(), languageId -> new ArrayList());
            ddmFieldAttributeInfos.add(new DDMFieldAttributeInfo(ddmFieldAttribute.getAttributeName(), ddmFieldAttribute.getAttributeValue(), ddmFieldInfo, ddmFieldAttribute.getLanguageId()));
        }
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        DDMField rootDDMField = null;
        for (DDMField ddmField : ddmFields) {
            if (!StringUtil.equals((String)ddmField.getFieldName(), (String)"")) continue;
            rootDDMField = ddmField;
            break;
        }
        if (rootDDMField == null) {
            rootDDMField = ddmFields.get(0);
        }
        DDMFieldInfo rootDDMFieldInfo = (DDMFieldInfo)ddmFieldInfoMap.remove(rootDDMField.getFieldId());
        for (DDMFieldAttributeInfo ddmFieldAttributeInfo : rootDDMFieldInfo._ddmFieldAttributeInfos.get("")) {
            String attributeName = ddmFieldAttributeInfo._attributeName;
            if (Objects.equals(attributeName, "availableLanguageIds")) {
                for (String availableLanguageId : com.liferay.petra.string.StringUtil.split((String)ddmFieldAttributeInfo._attributeValue)) {
                    ddmFormValues.addAvailableLocale(LocaleUtil.fromLanguageId((String)availableLanguageId));
                }
                continue;
            }
            if (!Objects.equals(attributeName, "defaultLanguageId")) continue;
            ddmFormValues.setDefaultLocale(LocaleUtil.fromLanguageId((String)ddmFieldAttributeInfo._attributeValue));
        }
        for (DDMFieldInfo ddmFieldInfo : ddmFieldInfoMap.values()) {
            if (ddmFieldInfo._parentInstanceId != null) continue;
            ddmFormValues.addDDMFormFieldValue(this._getDDMFormFieldValue(ddmFieldInfo, ddmFormValues.getDefaultLocale()));
        }
        return ddmFormValues;
    }

    private String _getKey(String ... parameters) {
        return com.liferay.petra.string.StringUtil.merge((String[])parameters, (String)"#");
    }

    private String _getValueString(List<DDMFieldAttributeInfo> ddmFieldAttributeInfos) {
        if (ddmFieldAttributeInfos.size() == 1) {
            DDMFieldAttributeInfo ddmFieldAttributeInfo = ddmFieldAttributeInfos.get(0);
            if (ddmFieldAttributeInfo._attributeName.isEmpty()) {
                return ddmFieldAttributeInfo._attributeValue;
            }
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (DDMFieldAttributeInfo ddmFieldAttributeInfo : ddmFieldAttributeInfos) {
            jsonObject.put(ddmFieldAttributeInfo._attributeName, this._jsonFactory.looseDeserialize(ddmFieldAttributeInfo._attributeValue));
        }
        return jsonObject.toString();
    }

    private boolean _persistReadOnlyValues(DDMField ddmField, List<Map.Entry<DDMFieldAttribute, DDMFieldAttributeInfo>> ddmFieldAttributeEntries, Map<String, DDMFieldInfo> ddmFieldInfoMap, Map<Long, Map<String, DDMFieldAttribute>> ddmFieldsAttributesMap, Map<String, DDMFormField> ddmFormFieldsMap) {
        if (ddmField == null || !ddmFieldsAttributesMap.containsKey(ddmField.getFieldId())) {
            return false;
        }
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmField.getFieldName());
        if (ddmFormField == null || !GetterUtil.getBoolean((Object)ddmFormField.getProperty("persistReadOnlyValue"))) {
            return false;
        }
        Map<String, DDMFieldAttribute> ddmFieldAttributesMap = ddmFieldsAttributesMap.get(ddmField.getFieldId());
        for (DDMFieldAttribute ddmFieldAttribute : ddmFieldAttributesMap.values()) {
            ddmFieldAttributeEntries.add(new AbstractMap.SimpleImmutableEntry<DDMFieldAttribute, DDMFieldAttributeInfo>(ddmFieldAttribute, new DDMFieldAttributeInfo(ddmFieldAttribute.getAttributeName(), ddmFieldAttribute.getAttributeValue(), ddmFieldInfoMap.get(ddmField.getInstanceId()), ddmFieldAttribute.getLanguageId())));
        }
        ddmFieldsAttributesMap.remove(ddmField.getFieldId());
        return true;
    }

    private static class DDMFieldInfo {
        private final List<DDMFieldInfo> _childDDMFieldInfos = new ArrayList<DDMFieldInfo>();
        private final Map<String, List<DDMFieldAttributeInfo>> _ddmFieldAttributeInfos = new HashMap<String, List<DDMFieldAttributeInfo>>();
        private final String _fieldName;
        private final String _instanceId;
        private final boolean _localizable;
        private final String _parentInstanceId;

        private DDMFieldInfo(String fieldName, String instanceId, boolean localizable, String parentInstanceId) {
            this._fieldName = fieldName;
            this._instanceId = instanceId;
            this._localizable = localizable;
            this._parentInstanceId = parentInstanceId;
        }
    }

    private static class DDMFieldAttributeInfo {
        private final String _attributeName;
        private final String _attributeValue;
        private final DDMFieldInfo _ddmFieldInfo;
        private final String _languageId;

        private DDMFieldAttributeInfo(String attributeName, String attributeValue, DDMFieldInfo ddmFieldInfo, String languageId) {
            this._attributeName = attributeName;
            this._attributeValue = attributeValue;
            this._ddmFieldInfo = ddmFieldInfo;
            this._languageId = languageId;
        }
    }

    private static class DDMFormUpdateContext {
        private final List<Map.Entry<DDMFieldAttribute, DDMFieldAttributeInfo>> _ddmFieldAttributeEntries;
        private final List<Map.Entry<DDMField, DDMFieldInfo>> _ddmFieldEntries;
        private final int _newDDMFieldAttributesCount;
        private final int _newDDMFieldsCount;

        private DDMFormUpdateContext(List<Map.Entry<DDMFieldAttribute, DDMFieldAttributeInfo>> ddmFieldAttributeEntries, List<Map.Entry<DDMField, DDMFieldInfo>> ddmFieldEntries, int newDDMFieldAttributesCount, int newDDMFieldsCount) {
            this._ddmFieldAttributeEntries = ddmFieldAttributeEntries;
            this._ddmFieldEntries = ddmFieldEntries;
            this._newDDMFieldAttributesCount = newDDMFieldAttributesCount;
            this._newDDMFieldsCount = newDDMFieldsCount;
        }
    }
}

