/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_7_3;

import com.liferay.dynamic.data.mapping.internal.report.CheckboxMultipleDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.NumericDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.RadioDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.internal.report.TextDDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DDMFormInstanceReportUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceReportUpgradeProcess.class);
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceReportUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this.runSQL("delete from DDMFormInstanceReport");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMFormInstance.formInstanceId, ", "DDMFormInstance.groupId, DDMFormInstance.companyId, ", "DDMFormInstance.createDate, DDMStructure.definition from ", "DDMFormInstance inner join DDMStructure on ", "DDMFormInstance.structureId = DDMStructure.structureId"}));
             PreparedStatement preparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.data_, DDMFormInstanceRecord.", "formInstanceRecordId, DDMStructureVersion.definition ", "from DDMContent inner join DDMFormInstanceRecordVersion ", "on DDMContent.contentId = DDMFormInstanceRecordVersion.", "storageId inner join DDMFormInstanceRecord on ", "DDMFormInstanceRecord.formInstanceRecordId = ", "DDMFormInstanceRecordVersion.formInstanceRecordId inner ", "join DDMFormInstanceVersion on DDMFormInstanceVersion.", "formInstanceId = DDMFormInstanceRecordVersion.", "formInstanceId and DDMFormInstanceVersion.version = ", "DDMFormInstanceRecordVersion.formInstanceVersion inner ", "join DDMStructureVersion on DDMStructureVersion.", "structureVersionId = DDMFormInstanceVersion.", "structureVersionId where DDMFormInstanceRecord.version = ", "DDMFormInstanceRecordVersion.version and ", "DDMFormInstanceRecord.formInstanceId = ? and ", "DDMFormInstanceRecordVersion.status = ?"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMFormInstanceReport ", "(formInstanceReportId, groupId, companyId, ", "createDate, modifiedDate, formInstanceId, data_) ", "values (?, ?, ?, ?, ?, ?, ?)"}));
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                JSONObject dataJSONObject = this._jsonFactory.createJSONObject();
                long formInstanceId = resultSet1.getLong("formInstanceId");
                preparedStatement2.setLong(1, formInstanceId);
                preparedStatement2.setInt(2, 0);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)resultSet1.getString("definition"));
                while (resultSet2.next()) {
                    dataJSONObject = this._processDDMFormValues(dataJSONObject, this._getDDMFormValues(resultSet2.getString("data_"), DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)resultSet2.getString("definition")), ddmForm.getDDMFormFieldsMap(true)), resultSet2.getLong("formInstanceRecordId"));
                    dataJSONObject.put("totalItems", dataJSONObject.getInt("totalItems") + 1);
                }
                if (dataJSONObject.length() == 0) continue;
                long groupId = resultSet1.getLong("groupId");
                long companyId = resultSet1.getLong("companyId");
                Timestamp createDate = resultSet1.getTimestamp("createDate");
                preparedStatement3.setLong(1, this.increment());
                preparedStatement3.setLong(2, groupId);
                preparedStatement3.setLong(3, companyId);
                preparedStatement3.setTimestamp(4, createDate);
                preparedStatement3.setTimestamp(5, createDate);
                preparedStatement3.setLong(6, formInstanceId);
                preparedStatement3.setString(7, dataJSONObject.toString());
                preparedStatement3.execute();
            }
        }
    }

    private DDMFormFieldTypeReportProcessor _getDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField, String type) {
        if (StringUtil.equals((String)type, (String)"checkbox_multiple") || StringUtil.equals((String)type, (String)"select")) {
            return new CheckboxMultipleDDMFormFieldTypeReportProcessor(this._jsonFactory);
        }
        if (StringUtil.equals((String)type, (String)"color") || StringUtil.equals((String)type, (String)"date") || StringUtil.equals((String)type, (String)"text")) {
            return new TextDDMFormFieldTypeReportProcessor(this._jsonFactory);
        }
        if (StringUtil.equals((String)type, (String)"grid")) {
            return new UpgradeGridDDMFormFieldTypeReportProcessor(ddmFormField);
        }
        if (StringUtil.equals((String)type, (String)"numeric")) {
            return new NumericDDMFormFieldTypeReportProcessor(this._jsonFactory);
        }
        if (StringUtil.equals((String)type, (String)"radio")) {
            return new RadioDDMFormFieldTypeReportProcessor();
        }
        return null;
    }

    private DDMFormValues _getDDMFormValues(String data, DDMForm ddmForm, Map<String, DDMFormField> ddmFormFieldsMap) throws Exception {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
        for (JSONObject jsonObject : fieldValuesJSONArray) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setDDMFormValues(ddmFormValues);
            ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
            ddmFormFieldValue.setName(jsonObject.getString("name"));
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
            if (ddmFormField == null || !StringUtil.equals((String)ddmFormField.getType(), (String)ddmFormFieldValue.getType())) continue;
            LocalizedValue value = null;
            if (ddmFormField.isLocalizable()) {
                value = new LocalizedValue();
                JSONObject valueJSONObject = jsonObject.getJSONObject("value");
                if (valueJSONObject == null) continue;
                for (String languageId : valueJSONObject.keySet()) {
                    value.addString(LocaleUtil.fromLanguageId((String)languageId), GetterUtil.getString((String)valueJSONObject.getString(languageId)));
                }
            } else {
                value = new UnlocalizedValue(GetterUtil.getString((Object)jsonObject.get("value")));
            }
            ddmFormFieldValue.setValue((Value)value);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
        return ddmFormValues;
    }

    private JSONObject _processDDMFormValues(JSONObject dataJSONObject, DDMFormValues ddmFormValues, long formInstanceRecordId) throws Exception {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getDDMFormField(), ddmFormFieldValue.getType());
            if (ddmFormFieldTypeReportProcessor == null) continue;
            String ddmFormFieldValueName = ddmFormFieldValue.getName();
            JSONObject fieldJSONObject = dataJSONObject.getJSONObject(ddmFormFieldValueName);
            if (fieldJSONObject == null) {
                fieldJSONObject = JSONUtil.put((String)"type", (Object)ddmFormFieldValue.getType()).put("values", this._jsonFactory.createJSONObject());
            }
            try {
                JSONObject processedFieldJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, this._jsonFactory.createJSONObject(fieldJSONObject.toString()), formInstanceRecordId, "add");
                dataJSONObject.put(ddmFormFieldValueName, processedFieldJSONObject);
            }
            catch (JSONException jsonException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)jsonException);
            }
        }
        return dataJSONObject;
    }

    private class UpgradeGridDDMFormFieldTypeReportProcessor
    implements DDMFormFieldTypeReportProcessor {
        private final DDMFormField _ddmFormField;

        public UpgradeGridDDMFormFieldTypeReportProcessor(DDMFormField ddmFormField) {
            this._ddmFormField = ddmFormField;
        }

        public JSONObject process(DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject, long formInstanceRecordId, String ddmFormInstanceReportEvent) throws Exception {
            JSONObject valuesJSONObject = fieldJSONObject.getJSONObject("values");
            Value value = ddmFormFieldValue.getValue();
            JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value.getString(value.getDefaultLocale()));
            Iterator iterator = valueJSONObject.keys();
            while (iterator.hasNext()) {
                String rowName = (String)iterator.next();
                JSONObject rowJSONObject = valuesJSONObject.getJSONObject(rowName);
                if (rowJSONObject == null) {
                    rowJSONObject = JSONFactoryUtil.createJSONObject();
                }
                String columnName = valueJSONObject.getString(rowName);
                rowJSONObject.put(columnName, rowJSONObject.getInt(columnName) + 1);
                valuesJSONObject.put(rowName, rowJSONObject);
            }
            int totalEntries = fieldJSONObject.getInt("totalEntries");
            if (valueJSONObject.length() != 0) {
                ++totalEntries;
            }
            fieldJSONObject.put("structure", JSONUtil.put((String)"columns", (Object)this._getOptionValuesJSONArray("columns")).put("rows", this._getOptionValuesJSONArray("rows"))).put("totalEntries", totalEntries);
            return fieldJSONObject;
        }

        private JSONArray _getOptionValuesJSONArray(String propertyName) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)this._ddmFormField.getProperty(propertyName);
            if (ddmFormFieldOptions != null) {
                Set optionsValues = ddmFormFieldOptions.getOptionsValues();
                optionsValues.forEach(optionValue -> jsonArray.put(optionValue));
            }
            return jsonArray;
        }
    }
}

