/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_1_0;

import com.liferay.dynamic.data.mapping.internal.upgrade.v4_1_0.util.DDMFieldAttributeTable;
import com.liferay.dynamic.data.mapping.internal.upgrade.v4_1_0.util.DDMFieldTable;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMField;
import com.liferay.dynamic.data.mapping.model.DDMFieldAttribute;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LRUMap;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMFieldUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DDL_RECORD_SET = "com.liferay.dynamic.data.lists.model.DDLRecordSet";
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldUpgradeProcess.class);
    private final Map<Long, DDMForm> _ddmForms = new LRUMap(1000);
    private final Map<Long, DDMForm> _fullHierarchyDDMForms = new LRUMap(1000);
    private final DDMFormDeserializer _jsonDDMFormJSONDeserializer;
    private final DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    private final JSONFactory _jsonFactory;

    public DDMFieldUpgradeProcess(JSONFactory jsonFactory, DDMFormDeserializer jsonDDMFormJSONDeserializer, DDMFormValuesDeserializer jsonDDMFormValuesDeserializer) {
        this._jsonFactory = jsonFactory;
        this._jsonDDMFormJSONDeserializer = jsonDDMFormJSONDeserializer;
        this._jsonDDMFormValuesDeserializer = jsonDDMFormValuesDeserializer;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.contentId, DDMContent.companyId, ", "DDMContent.data_, DDMStorageLink.structureVersionId, ", "DDMStructure.structureId, DDMStructure.classNameId ", "from DDMContent inner join DDMStorageLink on ", "DDMStorageLink.classPK = DDMContent.contentId inner ", "join DDMStructureVersion on ", "DDMStructureVersion.structureVersionId = ", "DDMStorageLink.structureVersionId inner join ", "DDMStructure on DDMStructureVersion.structureId = ", "DDMStructure.structureId where ", "DDMStructure.storageType = 'json' and ", "DDMContent.ctCollectionId = 0 and ", "DDMStorageLink.ctCollectionId = 0 and ", "DDMStructureVersion.ctCollectionId = 0 and ", "DDMStructure.ctCollectionId = 0"}));
             PreparedStatement insertDDMFieldPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMField (mvccVersion, ctCollectionId, ", "fieldId, companyId, parentFieldId, storageId, ", "structureVersionId, fieldName, fieldType, ", "instanceId, localizable, priority) values (0, 0, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             PreparedStatement insertDDMFieldAttributePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMFieldAttribute (mvccVersion, ", "ctCollectionId, fieldAttributeId, companyId, ", "fieldId, storageId, attributeName, languageId, ", "largeAttributeValue, smallAttributeValue) values (0, ", "0, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             PreparedStatement deleteDDMContentPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"delete from DDMContent where contentId = ? and ctCollectionId = 0");
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                this._upgradeDDMContent(resultSet.getLong("classNameId"), resultSet.getLong("companyId"), resultSet.getLong("contentId"), insertDDMFieldAttributePreparedStatement, insertDDMFieldPreparedStatement, resultSet.getString("data_"), deleteDDMContentPreparedStatement, resultSet.getLong("structureId"), resultSet.getLong("structureVersionId"));
            }
            insertDDMFieldPreparedStatement.executeBatch();
            insertDDMFieldAttributePreparedStatement.executeBatch();
            deleteDDMContentPreparedStatement.executeBatch();
        }
        this._ddmForms.clear();
        this._fullHierarchyDDMForms.clear();
        this.runSQL("update DDMStructure set storageType = 'default' where storageType = 'json'");
        this.runSQL("update DDMStructureVersion set storageType = 'default' where storageType = 'json'");
        selectPreparedStatement = this.connection.prepareStatement("select formInstanceId, settings_ from DDMFormInstance where ctCollectionId = 0");
        try (ResultSet resultSet = selectPreparedStatement.executeQuery();
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update DDMFormInstance set settings_ = ? where formInstanceId = ? and ctCollectionId = 0");){
            while (resultSet.next()) {
                String settings = resultSet.getString("settings_");
                if (!Validator.isNotNull((String)settings)) continue;
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(settings);
                JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
                for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
                    JSONObject jsonObject = fieldValuesJSONArray.getJSONObject(i);
                    if (!Objects.equals(jsonObject.getString("name"), "storageType")) continue;
                    JSONArray oldJSONArray = this._jsonFactory.createJSONArray(jsonObject.getString("value"));
                    JSONArray newJSONArray = this._jsonFactory.createJSONArray();
                    for (Object value : oldJSONArray) {
                        if (Objects.equals(value, "json")) {
                            value = "default";
                        }
                        newJSONArray.put(value);
                    }
                    jsonObject.put("value", newJSONArray);
                    break;
                }
                updatePreparedStatement.setString(1, settingsJSONObject.toString());
                updatePreparedStatement.setLong(2, resultSet.getLong("formInstanceId"));
                updatePreparedStatement.addBatch();
            }
            updatePreparedStatement.executeBatch();
        }
        finally {
            if (selectPreparedStatement != null) {
                selectPreparedStatement.close();
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{DDMFieldTable.create(), DDMFieldAttributeTable.create()};
    }

    private void _addDDMFieldAndDDMFieldAttribute(long companyId, long contentId, Map<String, DDMFieldInfo> ddmFieldInfoMap, Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormValues, PreparedStatement insertDDMFieldAttributePreparedStatement, PreparedStatement insertDDMFieldPreparedStatement, Map<String, Long> instanceToFieldIdMap, String parentInstanceId, int priority, DDMFieldInfo rootDDMFieldInfo, long structureVersionId) throws Exception {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues) {
            DDMFormField ddmFormField;
            long fieldId = this.increment(DDMField.class.getName());
            String instanceId = ddmFormFieldValue.getInstanceId();
            if (ddmFieldInfoMap.containsKey(instanceId)) {
                instanceId = StringUtil.randomString((int)8);
            }
            DDMFieldInfo ddmFieldInfo = new DDMFieldInfo(ddmFormFieldValue.getName(), instanceId, parentInstanceId);
            ddmFieldInfoMap.put(ddmFieldInfo._instanceId, ddmFieldInfo);
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                Map values = value.getValues();
                for (Map.Entry entry : values.entrySet()) {
                    ddmFieldInfo._ddmFieldAttributeInfos.addAll(this._getDDMFieldAttributeInfos(companyId, contentId, fieldId, insertDDMFieldAttributePreparedStatement, LanguageUtil.getLanguageId((Locale)((Locale)entry.getKey())), (String)entry.getValue()));
                }
            }
            long parentFieldId = 0L;
            if (ddmFieldInfo._parentInstanceId != null) {
                parentFieldId = instanceToFieldIdMap.get(ddmFieldInfo._parentInstanceId);
            }
            String fieldType = "";
            boolean localizable = false;
            if (ddmFieldInfo != rootDDMFieldInfo && (ddmFormField = ddmFormFieldsMap.get(ddmFieldInfo._fieldName)) != null) {
                fieldType = ddmFormField.getType();
                localizable = ddmFormField.isLocalizable();
            }
            insertDDMFieldPreparedStatement.setLong(1, fieldId);
            insertDDMFieldPreparedStatement.setLong(2, companyId);
            insertDDMFieldPreparedStatement.setLong(3, parentFieldId);
            insertDDMFieldPreparedStatement.setLong(4, contentId);
            insertDDMFieldPreparedStatement.setLong(5, structureVersionId);
            insertDDMFieldPreparedStatement.setString(6, ddmFieldInfo._fieldName);
            insertDDMFieldPreparedStatement.setString(7, fieldType);
            insertDDMFieldPreparedStatement.setString(8, ddmFieldInfo._instanceId);
            insertDDMFieldPreparedStatement.setBoolean(9, localizable);
            insertDDMFieldPreparedStatement.setInt(10, priority);
            insertDDMFieldPreparedStatement.addBatch();
            instanceToFieldIdMap.put(ddmFieldInfo._instanceId, fieldId);
            this._addDDMFieldAndDDMFieldAttribute(companyId, contentId, ddmFieldInfoMap, ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues(), insertDDMFieldAttributePreparedStatement, insertDDMFieldPreparedStatement, instanceToFieldIdMap, ddmFieldInfo._instanceId, ++priority, rootDDMFieldInfo, structureVersionId);
        }
    }

    private void _addRootDDMFieldAndDDMFieldAttribute(long companyId, long contentId, PreparedStatement insertDDMFieldAttributePreparedStatement, PreparedStatement insertDDMFieldPreparedStatement, Map<String, Long> instanceToFieldIdMap, DDMFieldInfo rootDDMFieldInfo, long structureVersionId) throws Exception {
        long fieldId = this.increment(DDMField.class.getName());
        insertDDMFieldPreparedStatement.setLong(1, fieldId);
        insertDDMFieldPreparedStatement.setLong(2, companyId);
        insertDDMFieldPreparedStatement.setLong(3, 0L);
        insertDDMFieldPreparedStatement.setLong(4, contentId);
        insertDDMFieldPreparedStatement.setLong(5, structureVersionId);
        insertDDMFieldPreparedStatement.setString(6, rootDDMFieldInfo._fieldName);
        insertDDMFieldPreparedStatement.setString(7, "");
        insertDDMFieldPreparedStatement.setString(8, rootDDMFieldInfo._instanceId);
        insertDDMFieldPreparedStatement.setBoolean(9, false);
        insertDDMFieldPreparedStatement.setInt(10, 0);
        insertDDMFieldPreparedStatement.addBatch();
        instanceToFieldIdMap.put(rootDDMFieldInfo._instanceId, fieldId);
        for (DDMFieldAttributeInfo ddmFieldAttributeInfo : rootDDMFieldInfo._ddmFieldAttributeInfos) {
            this._insertDDMFieldAttribute(companyId, contentId, ddmFieldAttributeInfo, fieldId, insertDDMFieldAttributePreparedStatement);
        }
    }

    private List<DDMFieldAttributeInfo> _getDDMFieldAttributeInfos(long companyId, long contentId, long fieldId, PreparedStatement insertDDMFieldAttributePreparedStatement, String languageId, String valueString) throws Exception {
        block5: {
            int length = valueString.length();
            if (length > 1 && valueString.charAt(0) == '{' && valueString.charAt(length - 1) == '}') {
                try {
                    JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
                    Set keySet = jsonObject.keySet();
                    if (!keySet.isEmpty()) {
                        ArrayList<DDMFieldAttributeInfo> ddmFieldAttributeInfos = new ArrayList<DDMFieldAttributeInfo>(keySet.size());
                        for (String key : jsonObject.keySet()) {
                            DDMFieldAttributeInfo ddmFieldAttributeInfo = new DDMFieldAttributeInfo(key, jsonSerializer.serialize(jsonObject.get(key)), languageId);
                            this._insertDDMFieldAttribute(companyId, contentId, ddmFieldAttributeInfo, fieldId, insertDDMFieldAttributePreparedStatement);
                            ddmFieldAttributeInfos.add(ddmFieldAttributeInfo);
                        }
                        return ddmFieldAttributeInfos;
                    }
                }
                catch (JSONException jsonException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to parse: " + valueString), (Throwable)jsonException);
                }
            }
        }
        DDMFieldAttributeInfo ddmFieldAttributeInfo = new DDMFieldAttributeInfo("", valueString, languageId);
        this._insertDDMFieldAttribute(companyId, contentId, ddmFieldAttributeInfo, fieldId, insertDDMFieldAttributePreparedStatement);
        return Collections.singletonList(ddmFieldAttributeInfo);
    }

    private DDMForm _getDDMForm(long structureId, long structureVersionId) throws Exception {
        DDMForm ddmForm = this._ddmForms.get(structureVersionId);
        if (ddmForm != null) {
            return ddmForm;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select definition from DDMStructureVersion where structureId = ? and structureVersionId = ? and ctCollectionId = 0");){
            preparedStatement.setLong(1, structureId);
            preparedStatement.setLong(2, structureVersionId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._jsonDDMFormJSONDeserializer, (String)resultSet.getString("definition"));
                    this._ddmForms.put(structureVersionId, ddmForm);
                    DDMForm dDMForm = ddmForm;
                    return dDMForm;
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureVersionId);
    }

    private DDMForm _getFullHierarchyDDMForm(long structureId, long structureVersionId) throws Exception {
        block32: {
            DDMForm fullHierarchyDDMForm = this._fullHierarchyDDMForms.get(structureVersionId);
            if (fullHierarchyDDMForm != null) {
                return fullHierarchyDDMForm;
            }
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select parentStructureId from DDMStructureVersion where structureId = ? and structureVersionId = ? and ctCollectionId = 0");){
                PreparedStatement preparedStatement2 = this.connection.prepareStatement("select max(structureVersionId) from DDMStructureVersion where structureId = ?");
                preparedStatement1.setLong(1, structureId);
                preparedStatement1.setLong(2, structureVersionId);
                ResultSet resultSet1 = preparedStatement1.executeQuery();
                if (!resultSet1.next()) break block32;
                long parentStructureId = resultSet1.getLong("parentStructureId");
                fullHierarchyDDMForm = this._getDDMForm(structureId, structureVersionId);
                this._fullHierarchyDDMForms.put(structureVersionId, fullHierarchyDDMForm);
                if (parentStructureId <= 0L) {
                    DDMForm dDMForm = fullHierarchyDDMForm;
                    return dDMForm;
                }
                preparedStatement2.setLong(1, parentStructureId);
                try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                    if (resultSet2.next()) {
                        DDMForm parentDDMForm = this._getFullHierarchyDDMForm(parentStructureId, resultSet2.getLong(1));
                        List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
                        ddmFormFields.addAll(parentDDMForm.getDDMFormFields());
                    }
                }
                DDMForm dDMForm = fullHierarchyDDMForm;
                return dDMForm;
                {
                    finally {
                        if (resultSet1 != null) {
                            resultSet1.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement2 != null) {
                        preparedStatement2.close();
                    }
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
    }

    private void _insertDDMFieldAttribute(long companyId, long contentId, DDMFieldAttributeInfo ddmFieldAttributeInfo, long fieldId, PreparedStatement insertDDMFieldAttributePreparedStatement) throws Exception {
        String smallAttributeValue = null;
        String largeAttributeValue = null;
        if (ddmFieldAttributeInfo._attributeValue != null) {
            if (ddmFieldAttributeInfo._attributeValue.length() > 255) {
                largeAttributeValue = ddmFieldAttributeInfo._attributeValue;
            } else {
                smallAttributeValue = ddmFieldAttributeInfo._attributeValue;
            }
        }
        insertDDMFieldAttributePreparedStatement.setLong(1, this.increment(DDMFieldAttribute.class.getName()));
        insertDDMFieldAttributePreparedStatement.setLong(2, companyId);
        insertDDMFieldAttributePreparedStatement.setLong(3, fieldId);
        insertDDMFieldAttributePreparedStatement.setLong(4, contentId);
        insertDDMFieldAttributePreparedStatement.setString(5, ddmFieldAttributeInfo._attributeName);
        insertDDMFieldAttributePreparedStatement.setString(6, ddmFieldAttributeInfo._languageId);
        insertDDMFieldAttributePreparedStatement.setString(7, largeAttributeValue);
        insertDDMFieldAttributePreparedStatement.setString(8, smallAttributeValue);
        insertDDMFieldAttributePreparedStatement.addBatch();
    }

    private void _upgradeDDMContent(long classNameId, long companyId, long contentId, PreparedStatement insertDDMFieldAttributePreparedStatement, PreparedStatement insertDDMFieldPreparedStatement, String data, PreparedStatement deleteDDMContentPreparedStatement, long structureId, long structureVersionId) throws Exception {
        DDMForm ddmForm = this._getFullHierarchyDDMForm(structureId, structureVersionId);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)data, (DDMForm)ddmForm).build());
        if (ddmFormValuesDeserializerDeserializeResponse.getException() != null) {
            throw ddmFormValuesDeserializerDeserializeResponse.getException();
        }
        DDMFormValues ddmFormValues = ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
        if (classNameId != PortalUtil.getClassNameId((String)_CLASS_NAME_DDL_RECORD_SET)) {
            ddmFormValues.setDDMFormFieldValues(this._upgradeDDMFormValuesHierarchy(ddmFormValues.getDDMFormFieldValues(), contentId));
        }
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFieldInfo rootDDMFieldInfo = new DDMFieldInfo("", "", null);
        LinkedHashMap ddmFieldInfoMap = LinkedHashMapBuilder.put((Object)"", (Object)rootDDMFieldInfo).build();
        Collections.addAll(rootDDMFieldInfo._ddmFieldAttributeInfos, new DDMFieldAttributeInfo("availableLanguageIds", com.liferay.petra.string.StringUtil.merge((Collection)ddmFormValues.getAvailableLocales(), LocaleUtil::toLanguageId, (String)","), ""), new DDMFieldAttributeInfo("defaultLanguageId", LocaleUtil.toLanguageId((Locale)ddmFormValues.getDefaultLocale()), ""));
        HashMap<String, Long> instanceToFieldIdMap = new HashMap<String, Long>();
        this._addRootDDMFieldAndDDMFieldAttribute(companyId, contentId, insertDDMFieldAttributePreparedStatement, insertDDMFieldPreparedStatement, instanceToFieldIdMap, rootDDMFieldInfo, structureVersionId);
        this._addDDMFieldAndDDMFieldAttribute(companyId, contentId, ddmFieldInfoMap, ddmFormFieldsMap, ddmFormValues.getDDMFormFieldValues(), insertDDMFieldAttributePreparedStatement, insertDDMFieldPreparedStatement, instanceToFieldIdMap, null, 1, rootDDMFieldInfo, structureVersionId);
        deleteDDMContentPreparedStatement.setLong(1, contentId);
        deleteDDMContentPreparedStatement.addBatch();
    }

    private List<DDMFormFieldValue> _upgradeDDMFormValuesHierarchy(List<DDMFormFieldValue> ddmFormFieldValues, long contentId) {
        return TransformUtil.transform(ddmFormFieldValues, ddmFormFieldValue -> {
            String type = ddmFormFieldValue.getType();
            if (ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues()) && type != null && !StringUtil.equals((String)type, (String)"fieldset")) {
                DDMFormFieldValue newDDMFormFieldValue = new DDMFormFieldValue((DDMFormFieldValue)ddmFormFieldValue){
                    final /* synthetic */ DDMFormFieldValue val$ddmFormFieldValue;
                    {
                        this.val$ddmFormFieldValue = dDMFormFieldValue;
                        this.setInstanceId(StringUtil.randomString());
                        this.setName(this.val$ddmFormFieldValue.getName() + "FieldSet");
                    }
                };
                ArrayList<DDMFormFieldValue> nestedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(ddmFormFieldValue.getNestedDDMFormFieldValues());
                ddmFormFieldValue.setNestedDDMFormFields(new ArrayList());
                newDDMFormFieldValue.setNestedDDMFormFields(ListUtil.concat((List[])new List[]{Collections.singletonList(ddmFormFieldValue), this._upgradeDDMFormValuesHierarchy(nestedDDMFormFieldValues, contentId)}));
                return newDDMFormFieldValue;
            }
            return ddmFormFieldValue;
        });
    }

    private static class DDMFieldInfo {
        private final List<DDMFieldAttributeInfo> _ddmFieldAttributeInfos = new ArrayList<DDMFieldAttributeInfo>();
        private final String _fieldName;
        private final String _instanceId;
        private final String _parentInstanceId;

        private DDMFieldInfo(String fieldName, String instanceId, String parentInstanceId) {
            this._fieldName = fieldName;
            this._instanceId = instanceId;
            this._parentInstanceId = parentInstanceId;
        }
    }

    private static class DDMFieldAttributeInfo {
        private final String _attributeName;
        private final String _attributeValue;
        private final String _languageId;

        private DDMFieldAttributeInfo(String attributeName, String attributeValue, String languageId) {
            this._attributeName = attributeName;
            this._attributeValue = attributeValue;
            this._languageId = languageId;
        }
    }
}

