/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.query.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={KeywordQueryContributor.class})
public class DDMFormInstanceRecordKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordKeywordQueryContributor.class);
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        this._addSearchLocalizedTerm(booleanQuery, "title", searchContext);
        this._addSearchLocalizedTerm(booleanQuery, "ddmContent", searchContext);
    }

    private void _addLocalizedBooleanQuery(BooleanQuery booleanQuery, BooleanQuery localizedBooleanQuery, SearchContext searchContext) {
        block3: {
            BooleanClauseOccur booleanClauseOccur = BooleanClauseOccur.SHOULD;
            if (searchContext.isAndSearch()) {
                booleanClauseOccur = BooleanClauseOccur.MUST;
            }
            try {
                booleanQuery.add((Query)localizedBooleanQuery, booleanClauseOccur);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to add localized boolean query ", localizedBooleanQuery, " with boolean clause occur ", booleanClauseOccur}), (Throwable)parseException);
            }
        }
    }

    private void _addLocalizedFields(BooleanQuery booleanQuery, String fieldName, SearchContext searchContext, String value) {
        for (String localizedFieldName : this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{fieldName}, searchContext)) {
            try {
                booleanQuery.addTerm(localizedFieldName, value, false);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to add search term to query field:", localizedFieldName, " value:", value, " like:", false}), (Throwable)parseException);
            }
        }
    }

    private void _addSearchLocalizedTerm(BooleanQuery booleanQuery, String fieldName, SearchContext searchContext) {
        String value = GetterUtil.getString((Object)searchContext.getAttribute(fieldName), (String)searchContext.getKeywords());
        if (Validator.isBlank((String)value)) {
            return;
        }
        if (Validator.isBlank((String)searchContext.getKeywords())) {
            BooleanQueryImpl localizedBooleanQuery = new BooleanQueryImpl();
            this._addLocalizedFields((BooleanQuery)localizedBooleanQuery, fieldName, searchContext, value);
            this._addLocalizedBooleanQuery(booleanQuery, (BooleanQuery)localizedBooleanQuery, searchContext);
        } else {
            this._addLocalizedFields(booleanQuery, fieldName, searchContext, value);
        }
    }
}

