/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.internal.petra.executor.DDMFormInstanceReportPortalExecutor;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DDMFormInstanceModelListener
extends BaseModelListener<DDMFormInstance> {
    @Reference
    protected DDMFormInstanceReportLocalService ddmFormInstanceReportLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceModelListener.class);
    @Reference
    private DDMFormInstanceReportPortalExecutor _ddmFormInstanceReportPortalExecutor;

    public void onAfterCreate(DDMFormInstance ddmFormInstance) throws ModelListenerException {
        block2: {
            try {
                this.ddmFormInstanceReportLocalService.addFormInstanceReport(ddmFormInstance.getFormInstanceId());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update dynamic data mapping form instance ", "report for dynamic data mapping form instance ", ddmFormInstance.getFormInstanceId()}), (Throwable)exception);
            }
        }
    }

    public void onBeforeRemove(DDMFormInstance ddmFormInstance) throws ModelListenerException {
        block2: {
            try {
                DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportLocalService.getFormInstanceReportByFormInstanceId(ddmFormInstance.getFormInstanceId());
                TransactionCommitCallbackUtil.registerCallback(() -> {
                    this._ddmFormInstanceReportPortalExecutor.execute(() -> this.ddmFormInstanceReportLocalService.deleteDDMFormInstanceReport(ddmFormInstanceReport.getFormInstanceReportId()));
                    return null;
                });
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update dynamic data mapping form instance ", "report for dynamic data mapping form instance ", ddmFormInstance.getFormInstanceId()}), (Throwable)exception);
            }
        }
    }
}

