/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.DDMFormInstanceNameComparator;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance"}, service={StagedModelRepository.class})
public class DDMFormInstanceStagedModelRepository
implements StagedModelRepository<DDMFormInstance> {
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public DDMFormInstance addStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstance.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstance);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddmFormInstance.getUuid());
        }
        return this._ddmFormInstanceLocalService.addFormInstance(userId, ddmFormInstance.getGroupId(), ddmFormInstance.getStructureId(), ddmFormInstance.getNameMap(), ddmFormInstance.getDescriptionMap(), ddmFormInstance.getSettings(), serviceContext);
    }

    public void deleteStagedModel(DDMFormInstance ddmFormInstance) throws PortalException {
        this._ddmFormInstanceLocalService.deleteFormInstance(ddmFormInstance);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMFormInstance ddmFormInstance = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmFormInstance != null) {
            this.deleteStagedModel(ddmFormInstance);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        HashSet<Long> formInstanceDDMStructureIds = new HashSet<Long>();
        List formInstances = this._ddmFormInstanceLocalService.search(portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), null, -1, -1, (OrderByComparator)DDMFormInstanceNameComparator.getInstance((boolean)false));
        for (DDMFormInstance formInstance : formInstances) {
            formInstanceDDMStructureIds.add(formInstance.getStructureId());
            this._ddmFormInstanceLocalService.deleteFormInstance(formInstance);
        }
        this._deleteDDMStructures(formInstanceDDMStructureIds);
    }

    public DDMFormInstance fetchMissingReference(String uuid, long groupId) {
        return (DDMFormInstance)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public DDMFormInstance fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddmFormInstanceLocalService.fetchDDMFormInstanceByUuidAndGroupId(uuid, groupId);
    }

    public List<DDMFormInstance> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddmFormInstanceLocalService.getDDMFormInstancesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmFormInstanceLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setPerformActionMethod(ddmFormInstance -> {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance.getStructure());
        });
        return exportActionableDynamicQuery;
    }

    public DDMFormInstance getStagedModel(long ddmFormInstanceId) throws PortalException {
        return this._ddmFormInstanceLocalService.getDDMFormInstance(ddmFormInstanceId);
    }

    public DDMFormInstance saveStagedModel(DDMFormInstance ddmFormInstance) throws PortalException {
        return this._ddmFormInstanceLocalService.updateDDMFormInstance(ddmFormInstance);
    }

    public DDMFormInstance updateStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws PortalException {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstance);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return this._ddmFormInstanceLocalService.updateFormInstance(serviceContext.getUserId(), ddmFormInstance.getFormInstanceId(), ddmFormInstance.getNameMap(), ddmFormInstance.getDescriptionMap(), ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout(), ddmFormInstance.getSettingsDDMFormValues(), serviceContext);
    }

    private void _deleteDDMStructures(Set<Long> ddmStructureIds) throws PortalException {
        for (Long ddmStructureId : ddmStructureIds) {
            if (this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId.longValue()) == null) continue;
            this._ddmStructureLocalService.deleteStructure(ddmStructureId.longValue());
        }
    }
}

