/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.NestedSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortBuilderFactory;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration"}, service={DDMIndexer.class})
public class DDMIndexerImpl
implements DDMIndexer {
    @Reference
    protected Queries queries;
    @Reference
    protected SearchEngineInformation searchEngineInformation;
    @Reference
    protected SortBuilderFactory sortBuilderFactory;
    @Reference
    protected Sorts sorts;
    private static final int _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH = GetterUtil.getInteger((String)PropsUtil.get((String)"index.sortable.text.fields.truncated.length"));
    private static final Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private volatile DDMIndexerConfiguration _ddmIndexerConfiguration;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private JSONFactory _jsonFactory;

    public void addAttributes(Document document, DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        boolean legacyDDMIndexFieldsEnabled = this.isLegacyDDMIndexFieldsEnabled();
        FieldArray fieldArray = (FieldArray)document.getField("ddmFieldArray");
        if (fieldArray == null && !legacyDDMIndexFieldsEnabled) {
            fieldArray = new FieldArray("ddmFieldArray");
            document.add((Field)fieldArray);
        }
        Set locales = ddmFormValues.getAvailableLocales();
        Fields fields = this._toFields(ddmStructure, ddmFormValues);
        for (com.liferay.dynamic.data.mapping.storage.Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType) || indexType.equals("none")) continue;
                DDMFormField ddmFormField = ddmStructure.getDDMFormField(field.getName());
                String name = null;
                Serializable value = null;
                if (GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(field.getName(), "localizable"))) {
                    for (Locale locale : locales) {
                        name = this.encodeName(ddmStructure.getStructureId(), ddmFormField.getFieldReference(), locale, indexType);
                        value = field.getValue(locale);
                        if (legacyDDMIndexFieldsEnabled) {
                            this._addToDocument(document, field, indexType, name, value);
                            continue;
                        }
                        if (value == null) continue;
                        fieldArray.addField(this.createField(ddmFormField, field, indexType, locale, name, value));
                    }
                    continue;
                }
                name = this.encodeName(ddmStructure.getStructureId(), ddmFormField.getFieldReference(), null, indexType);
                value = field.getValue(ddmFormValues.getDefaultLocale());
                if (legacyDDMIndexFieldsEnabled) {
                    this._addToDocument(document, field, indexType, name, value);
                    continue;
                }
                if (value == null) continue;
                fieldArray.addField(this.createField(ddmFormField, field, indexType, null, name, value));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)exception);
            }
        }
    }

    public Sort createDDMStructureFieldSort(DDMStructure ddmStructure, String fieldReference, Locale locale, SortOrder sortOrder) throws PortalException {
        DDMFormField ddmFormField = ddmStructure.getDDMFormFieldByFieldReference(fieldReference);
        if (GetterUtil.getBoolean((Object)ddmFormField.getProperty("localizable"))) {
            if (locale == null) {
                throw new IllegalArgumentException("Locale cannot be null if the dynamic data mapping form field is localizable");
            }
        } else {
            locale = null;
        }
        StringBundler sb = new StringBundler(5);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            sb.append(this.encodeName(ddmStructure.getStructureId(), fieldReference, locale));
        } else {
            sb.append("ddmFieldArray");
            sb.append(".");
            String indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
            sb.append(this.getValueFieldName(indexType, locale));
        }
        sb.append("_");
        String ddmFormFieldType = ddmFormField.getType();
        if (Objects.equals(ddmFormFieldType, "ddm-decimal") || Objects.equals(ddmFormFieldType, "ddm-integer") || Objects.equals(ddmFormFieldType, "ddm-number") || Objects.equals(ddmFormFieldType, "numeric")) {
            sb.append("Number");
        } else {
            sb.append("String");
        }
        FieldSort fieldSort = this.sorts.field(Field.getSortableFieldName((String)sb.toString()), sortOrder);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            return fieldSort;
        }
        NestedSort nestedSort = this.sorts.nested("ddmFieldArray");
        nestedSort.setFilterQuery((Query)this.queries.term(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), (Object)this.encodeName(ddmStructure.getStructureId(), fieldReference, locale)));
        fieldSort.setNestedSort(nestedSort);
        return fieldSort;
    }

    public Sort createDDMStructureFieldSort(String ddmStructureFieldName, Locale locale, SortOrder sortOrder) throws PortalException {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        long ddmStructureId = GetterUtil.getLong((String)ddmStructureFieldNameParts[2]);
        String fieldReference = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        return this.createDDMStructureFieldSort(ddmStructure, fieldReference, locale, sortOrder);
    }

    public QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String fieldReference, Locale locale, Serializable value) throws Exception {
        String indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
        return this.createFieldValueQueryFilter(ddmStructure, this.encodeName(ddmStructure.getStructureId(), fieldReference, locale), value, fieldReference, indexType, locale);
    }

    public QueryFilter createFieldValueQueryFilter(String ddmStructureFieldName, Serializable ddmStructureFieldValue, Locale locale) throws Exception {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
        String fieldReference = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        return this.createFieldValueQueryFilter(ddmStructure, ddmStructureFieldName, ddmStructureFieldValue, fieldReference, ddmStructureFieldNameParts[1], locale);
    }

    public String encodeName(long ddmStructureId, String fieldReference) {
        return this.encodeName(ddmStructureId, fieldReference, null);
    }

    public String encodeName(long ddmStructureId, String fieldReference, Locale locale) {
        DDMStructure ddmStructure;
        String indexType = "";
        boolean localizable = true;
        if (ddmStructureId > 0L && (ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId)) != null) {
            try {
                indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
                localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldPropertyByFieldReference(fieldReference, "localizable"));
            }
            catch (PortalException portalException) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to obtain index type for field ", fieldReference, " and DDM structure ID ", ddmStructureId}), portalException);
            }
        }
        if (localizable) {
            return this.encodeName(ddmStructureId, fieldReference, locale, indexType);
        }
        return this.encodeName(ddmStructureId, fieldReference, null, indexType);
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, DDMFormValues ddmFormValues, Locale locale) {
        StringBundler sb = new StringBundler();
        this._extractIndexableAttributes(ddmFormValues.getDDMFormFieldValues(), ddmStructure, ddmFormValues.getDefaultLocale(), locale, sb);
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getValueFieldName(String indexType) {
        return this.getValueFieldName(indexType, null);
    }

    public String getValueFieldName(String indexType, Locale locale) {
        String valueFieldName = "ddmFieldValue";
        if (indexType != null) {
            valueFieldName = valueFieldName.concat(StringUtil.upperCaseFirstLetter((String)indexType));
        }
        if (locale != null) {
            valueFieldName = StringBundler.concat((String[])new String[]{valueFieldName, "_", LocaleUtil.toLanguageId((Locale)locale)});
        }
        return valueFieldName;
    }

    public boolean isLegacyDDMIndexFieldsEnabled() {
        if (Objects.equals(this.searchEngineInformation.getVendorString(), "Solr")) {
            return true;
        }
        return this._ddmIndexerConfiguration.enableLegacyDDMIndexFields();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddmIndexerConfiguration = (DDMIndexerConfiguration)ConfigurableUtil.createConfigurable(DDMIndexerConfiguration.class, properties);
    }

    protected Field createField(DDMFormField ddmFormField, com.liferay.dynamic.data.mapping.storage.Field ddmStructureField, String indexType, Locale locale, String name, Serializable value) throws PortalException {
        Field ddmField = new Field("");
        SortedArrayList sortedFields = new SortedArrayList(Comparator.comparing(Field::getName));
        DocumentImpl document = new DocumentImpl();
        String valueFieldName = this.getValueFieldName(indexType, locale);
        this._addToDocument((Document)document, ddmStructureField, indexType, valueFieldName, (Serializable)((Object)this._getSortableValue(ddmFormField, locale, value)), value);
        Map documentFields = document.getFields();
        sortedFields.addAll(documentFields.values());
        sortedFields.add(new Field("ddmFieldName", name));
        sortedFields.add(new Field("ddmValueFieldName", valueFieldName));
        sortedFields.forEach(arg_0 -> ((Field)ddmField).addField(arg_0));
        return ddmField;
    }

    protected QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String ddmStructureFieldName, Serializable ddmStructureFieldValue, String fieldReference, String indexType, Locale locale) throws Exception {
        boolean localizable = false;
        if (ddmStructure.hasFieldByFieldReference(fieldReference)) {
            ddmStructureFieldValue = this._ddm.getIndexedFieldValue(ddmStructureFieldValue, ddmStructure.getFieldPropertyByFieldReference(fieldReference, "type"));
            localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldPropertyByFieldReference(fieldReference, "localizable"));
        }
        if (!localizable) {
            locale = null;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            this._addFieldValueRequiredTerm((BooleanQuery)booleanQuery, ddmStructureFieldName, ddmStructureFieldValue);
            return new QueryFilter((com.liferay.portal.kernel.search.Query)booleanQuery);
        }
        booleanQuery.addRequiredTerm(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), ddmStructureFieldName);
        this._addFieldValueRequiredTerm((BooleanQuery)booleanQuery, StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", this.getValueFieldName(indexType, locale)}), ddmStructureFieldValue);
        return new QueryFilter((com.liferay.portal.kernel.search.Query)new NestedQuery("ddmFieldArray", (com.liferay.portal.kernel.search.Query)booleanQuery));
    }

    protected String encodeName(long ddmStructureId, String fieldReference, Locale locale, String indexType) {
        StringBundler sb = new StringBundler(8);
        sb.append("ddm__");
        if (Validator.isNotNull((String)indexType)) {
            sb.append(indexType);
            sb.append("__");
        }
        sb.append(ddmStructureId);
        sb.append("__");
        sb.append(fieldReference);
        if (locale != null) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        } else if (this.isLegacyDDMIndexFieldsEnabled() && StringUtil.equals((String)fieldReference, (String)"date")) {
            sb.append("_");
        }
        return sb.toString();
    }

    private void _addFieldValue(StringBundler sb, String type, String valueString) throws Exception {
        if (type.equals("document_library") || type.equals("link_to_layout")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject != null && jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("image")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject == null) {
                return;
            }
            if (jsonObject.has("description") && Validator.isNotNull((String)jsonObject.getString("description"))) {
                sb.append(jsonObject.getString("description"));
            } else if (jsonObject.has("alt") && Validator.isNotNull((String)jsonObject.getString("alt"))) {
                sb.append(jsonObject.getString("alt"));
            } else if (jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("journal_article")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject == null) {
                return;
            }
            if (jsonObject.has("titleMap")) {
                JSONObject titleMapJSONObject = jsonObject.getJSONObject("titleMap");
                Iterator iterator = titleMapJSONObject.keys();
                while (iterator.hasNext()) {
                    sb.append(titleMapJSONObject.getString((String)iterator.next()));
                    if (!iterator.hasNext()) continue;
                    sb.append(" ");
                }
            } else if (jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("rich_text")) {
            sb.append(this._htmlParser.extractText(valueString));
        } else if (type.equals("select")) {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            sb.append(ArrayUtil.toStringArray((JSONArray)jsonArray));
        } else {
            sb.append(valueString);
        }
    }

    private void _addFieldValueRequiredTerm(BooleanQuery booleanQuery, String fieldName, Serializable fieldValue) {
        if (fieldValue instanceof String[]) {
            String[] fieldValueArray;
            for (String fieldValueString : fieldValueArray = (String[])fieldValue) {
                booleanQuery.addRequiredTerm(fieldName, "\"" + fieldValueString + "\"");
            }
        } else {
            booleanQuery.addRequiredTerm(fieldName, "\"" + String.valueOf(fieldValue) + "\"");
        }
    }

    private void _addToDocument(Document document, com.liferay.dynamic.data.mapping.storage.Field field, String indexType, String name, Serializable value) throws PortalException {
        this._addToDocument(document, field, indexType, name, value, value);
    }

    private void _addToDocument(Document document, com.liferay.dynamic.data.mapping.storage.Field field, String indexType, String name, Serializable sortableValue, Serializable value) throws PortalException {
        if (value != null) {
            if (value instanceof BigDecimal) {
                document.addNumberSortable(name, (BigDecimal)value);
            } else if (value instanceof BigDecimal[]) {
                document.addNumberSortable(name, (BigDecimal[])value);
            } else if (value instanceof Boolean) {
                document.addKeywordSortable(name, (Boolean)value);
            } else if (value instanceof Boolean[]) {
                document.addKeywordSortable(name, (Boolean[])value);
            } else if (value instanceof Date) {
                document.addDateSortable(name, (Date)value);
            } else if (value instanceof Date[]) {
                document.addDateSortable(name, (Date[])value);
            } else if (value instanceof Double) {
                document.addNumberSortable(name, (Double)value);
            } else if (value instanceof Double[]) {
                document.addNumberSortable(name, (Double[])value);
            } else if (value instanceof Integer) {
                document.addNumberSortable(name, (Integer)value);
            } else if (value instanceof Integer[]) {
                document.addNumberSortable(name, (Integer[])value);
            } else if (value instanceof Long) {
                document.addNumberSortable(name, (Long)value);
            } else if (value instanceof Long[]) {
                document.addNumberSortable(name, (Long[])value);
            } else if (value instanceof Float) {
                document.addNumberSortable(name, (Float)value);
            } else if (value instanceof Float[]) {
                document.addNumberSortable(name, (Float[])value);
            } else if (value instanceof Number[]) {
                Number[] numbers = (Number[])value;
                Double[] doubles = new Double[numbers.length];
                for (int i = 0; i < numbers.length; ++i) {
                    doubles[i] = numbers[i].doubleValue();
                }
                document.addNumberSortable(name, doubles);
            } else if (value instanceof Object[]) {
                String[] valuesString;
                String[] truncatedValuesString = valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                String type = field.getType();
                if (type.equals("date") || type.equals("date_time")) {
                    Date[] dateValues = this._getDateValues(type, valuesString);
                    if (dateValues.length > 0) {
                        document.addDate(name.concat("_date"), dateValues);
                    }
                } else if (type.equals("rich_text")) {
                    ArrayList<String> richTextValues = new ArrayList<String>(valuesString.length);
                    ArrayList<String> truncatedValues = new ArrayList<String>(valuesString.length);
                    for (String valueString : valuesString) {
                        String richTextValue = this._htmlParser.extractText(valueString);
                        richTextValues.add(richTextValue);
                        truncatedValues.add(this._truncate(richTextValue));
                    }
                    valuesString = richTextValues.toArray(new String[0]);
                    truncatedValuesString = truncatedValues.toArray(new String[0]);
                } else if (type.equals("text")) {
                    ArrayList<String> truncatedValues = new ArrayList<String>(valuesString.length);
                    for (String valueString : valuesString) {
                        truncatedValues.add(this._truncate(valueString));
                    }
                    truncatedValuesString = truncatedValues.toArray(new String[0]);
                }
                if (indexType.equals("keyword")) {
                    document.addKeywordSortable(name, valuesString);
                    document.addKeyword(this._getSortableFieldName(name), truncatedValuesString);
                } else {
                    document.addTextSortable(name, valuesString);
                    document.addText(this._getSortableFieldName(name), truncatedValuesString);
                }
            } else {
                String sortableValueString = StringUtil.toLowerCase((String)String.valueOf(sortableValue));
                String valueString = String.valueOf(value);
                String type = field.getType();
                if (type.equals("geolocation")) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
                    double latitude = jsonObject.getDouble("lat", 0.0);
                    double longitude = jsonObject.getDouble("lng", 0.0);
                    document.addGeoLocation(name.concat("_geolocation"), latitude, longitude);
                } else if (type.equals("select")) {
                    document.addKeyword(this._getFieldName(name), this._toStringArray(sortableValue));
                    document.addKeyword(this._getSortableFieldName(name), this._toStringArray(sortableValueString));
                    document.addKeyword(name, this._toStringArray(valueString));
                } else {
                    if ((type.equals("date") || type.equals("date_time")) && Validator.isNotNull((String)valueString)) {
                        Date[] dateValues = this._getDateValues(type, new String[]{valueString});
                        if (dateValues.length > 0) {
                            document.addDate(name.concat("_date"), dateValues);
                        }
                    } else if (type.equals("rich_text")) {
                        valueString = this._htmlParser.extractText(valueString);
                        sortableValueString = this._htmlParser.extractText(sortableValueString);
                    }
                    this._createSortableTextField(document, name, sortableValueString);
                    if (indexType.equals("keyword")) {
                        document.addKeyword(name, valueString);
                    } else {
                        document.addText(name, valueString);
                    }
                }
            }
        }
    }

    private void _createSortableTextField(Document document, String name, String sortableValueString) {
        if (Validator.isNull((String)sortableValueString)) {
            return;
        }
        document.addKeyword(this._getSortableFieldName(name), this._truncate(sortableValueString));
    }

    private void _extractIndexableAttribute(DDMFormField ddmFormField, Locale defaultLocale, String indexType, Locale locale, StringBundler sb, Value value) throws Exception {
        if (Validator.isNull((String)indexType) || indexType.equals("none") || value == null) {
            return;
        }
        Serializable serializable = FieldConstants.getSerializable((Locale)defaultLocale, (Locale)locale, (String)ddmFormField.getDataType(), (String)value.getString(locale));
        if (serializable == null || Validator.isBlank((String)String.valueOf(serializable))) {
            return;
        }
        if (serializable instanceof Boolean || serializable instanceof Number) {
            sb.append((Object)serializable);
        } else if (serializable instanceof Date) {
            Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
            sb.append(dateFormat.format(serializable));
        } else {
            this._addFieldValue(sb, ddmFormField.getType(), this._getSortableValue(ddmFormField, locale, serializable));
        }
        sb.append(" ");
    }

    private void _extractIndexableAttributes(List<DDMFormFieldValue> ddmFormFieldValues, DDMStructure ddmStructure, Locale defaultLocale, Locale locale, StringBundler sb) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            block5: {
                DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                if (ddmFormField == null) continue;
                try {
                    Locale ddmFormFieldLocale = locale;
                    if (!ddmFormField.isLocalizable()) {
                        ddmFormFieldLocale = LocaleUtil.ROOT;
                    }
                    this._extractIndexableAttribute(ddmFormField, defaultLocale, ddmStructure.getFieldProperty(ddmFormField.getName(), "indexType"), ddmFormFieldLocale, sb, ddmFormFieldValue.getValue());
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to index ", ddmFormField.getName(), " because it was deleted from the dynamic data ", "mapping structure ID", ddmStructure.getStructureId()}));
                }
            }
            if (!ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) continue;
            this._extractIndexableAttributes(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmStructure, defaultLocale, locale, sb);
        }
    }

    private Date[] _getDateValues(String type, String[] values) {
        ArrayList<Date> dateValues = new ArrayList<Date>(values.length);
        String pattern = "yyyy-MM-dd";
        if (type.equals("date_time")) {
            pattern = "yyyy-MM-dd hh:mm";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)pattern);
        for (String value : values) {
            if (Validator.isNull((String)value)) continue;
            try {
                dateValues.add(dateFormat.parse(value));
            }
            catch (ParseException parseException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)parseException);
            }
        }
        return dateValues.toArray(new Date[0]);
    }

    private String _getFieldName(String name) {
        return name + "_String";
    }

    private String _getSortableFieldName(String name) {
        return Field.getSortableFieldName((String)this._getFieldName(name));
    }

    private String _getSortableValue(DDMFormField ddmFormField, Locale locale, Serializable value) {
        if (value == null) {
            return null;
        }
        String sortableValue = String.valueOf(value);
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("options");
        Map options = ddmFormFieldOptions.getOptions();
        if (MapUtil.isEmpty((Map)options)) {
            return sortableValue;
        }
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            JSONArray sortableValueJSONArray = this._jsonFactory.createJSONArray(sortableValue);
            for (int i = 0; i < sortableValueJSONArray.length(); ++i) {
                LocalizedValue localizedValue = (LocalizedValue)options.get(sortableValueJSONArray.getString(i));
                if (localizedValue == null) {
                    jsonArray.put(sortableValueJSONArray.getString(i));
                    continue;
                }
                jsonArray.put(localizedValue.getString(locale));
            }
            return jsonArray.toString();
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            for (Map.Entry entry : options.entrySet()) {
                LocalizedValue localizedValue = (LocalizedValue)entry.getValue();
                sortableValue = StringUtil.replace((String)sortableValue, (String)((String)entry.getKey()), (String)localizedValue.getString(locale));
            }
            return sortableValue;
        }
    }

    private Fields _toFields(DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        try {
            return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to convert DDMFormValues to Fields", (Throwable)portalException);
            return new Fields();
        }
    }

    private String[] _toStringArray(Object value) throws PortalException {
        return ArrayUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray(String.valueOf(value)));
    }

    private String _truncate(String string) {
        if (string.length() > _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH) {
            return string.substring(0, _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH);
        }
        return string;
    }
}

