/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.instance.lifecycle;

import com.liferay.dynamic.data.lists.internal.configuration.DDLServiceConfiguration;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.osgi.util.configuration.ConfigurationPersistenceUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.lists.internal.configuration.DDLServiceConfiguration"}, service={PortalInstanceLifecycleListener.class})
public class AddDefaultDDLStructuresPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private volatile DDLServiceConfiguration _ddlServiceConfiguration;
    @Reference
    private DefaultDDMStructureHelper _defaultDDMStructureHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    private long _lastModifiedTime;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._ddlServiceConfiguration.addDefaultStructures()) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getCompanyGroup(company.getCompanyId());
        serviceContext.setScopeGroupId(group.getGroupId());
        long guestUserId = this._userLocalService.getGuestUserId(company.getCompanyId());
        serviceContext.setUserId(guestUserId);
        this._defaultDDMStructureHelper.addDDMStructures(guestUserId, group.getGroupId(), this._portal.getClassNameId(DDLRecordSet.class), AddDefaultDDLStructuresPortalInstanceLifecycleListener.class.getClassLoader(), "com/liferay/dynamic/data/lists/internal/events/dependencies/default-dynamic-data-lists-structures.xml", serviceContext);
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._lastModifiedTime = ConfigurationPersistenceUtil.update((Object)((Object)this), properties);
        this._ddlServiceConfiguration = (DDLServiceConfiguration)ConfigurableUtil.createConfigurable(DDLServiceConfiguration.class, properties);
    }
}

