/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={ModelDocumentContributor.class})
public class DDLRecordModelDocumentContributor
implements ModelDocumentContributor<DDLRecord> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected DDMIndexer ddmIndexer;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordModelDocumentContributor.class);

    public void contribute(Document document, DDLRecord ddlRecord) {
        block2: {
            try {
                DDLRecordVersion ddlRecordVersion = ddlRecord.getRecordVersion();
                DDLRecordSet ddlRecordSet = ddlRecordVersion.getRecordSet();
                document.addKeyword("classNameId", this.classNameLocalService.getClassNameId(DDLRecordSet.class));
                document.addKeyword("classPK", ddlRecordSet.getRecordSetId());
                document.addKeyword("classTypeId", ddlRecordVersion.getRecordSetId());
                document.addKeyword("relatedEntry", true);
                document.addKeyword("status", ddlRecordVersion.getStatus());
                document.addKeyword("version", ddlRecordVersion.getVersion());
                document.addKeyword("recordSetId", ddlRecordSet.getRecordSetId());
                document.addKeyword("recordSetScope", ddlRecordSet.getScope());
                DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
                DDMFormValues ddmFormValues = ddlRecordVersion.getDDMFormValues();
                this._addContent(ddlRecordVersion, ddmFormValues, document);
                this.ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _addContent(DDLRecordVersion ddlRecordVersion, DDMFormValues ddmFormValues, Document document) throws Exception {
        Set locales = ddmFormValues.getAvailableLocales();
        for (Locale locale : locales) {
            document.addText("ddmContent_" + LocaleUtil.toLanguageId((Locale)locale), this._extractContent(ddlRecordVersion, locale));
        }
    }

    private String _extractContent(DDLRecordVersion ddlRecordVersion, Locale locale) throws Exception {
        DDMFormValues ddmFormValues = ddlRecordVersion.getDDMFormValues();
        if (ddmFormValues == null) {
            return "";
        }
        DDLRecordSet ddlRecordSet = ddlRecordVersion.getRecordSet();
        return this.ddmIndexer.extractIndexableAttributes(ddlRecordSet.getDDMStructure(), ddmFormValues, locale);
    }
}

