/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={StagedModelRepository.class})
public class DDLRecordStagedModelRepository
implements StagedModelRepository<DDLRecord> {
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public DDLRecord addStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(DDLRecord ddlRecord) throws PortalException {
        this._ddlRecordLocalService.deleteRecord(ddlRecord);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDLRecord ddlRecord = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddlRecord != null) {
            this.deleteStagedModel(ddlRecord);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public DDLRecord fetchMissingReference(String uuid, long groupId) {
        return (DDLRecord)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public DDLRecord fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddlRecordLocalService.fetchDDLRecordByUuidAndGroupId(uuid, groupId);
    }

    public List<DDLRecord> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddlRecordLocalService.getDDLRecordsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this.getExportActionableDynamicQuery(portletDataContext, 0);
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext, int scope) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddlRecordLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property recordIdProperty = PropertyFactoryUtil.forName((String)"recordId");
            dynamicQuery.add(recordIdProperty.in(this._getRecordVersionDynamicQuery()));
            Property recordSetIdProperty = PropertyFactoryUtil.forName((String)"recordSetId");
            dynamicQuery.add(recordSetIdProperty.in(this._getRecordSetDynamicQuery(scope)));
        });
        return exportActionableDynamicQuery;
    }

    public DDLRecord getStagedModel(long recordId) throws PortalException {
        return this._ddlRecordLocalService.getDDLRecord(recordId);
    }

    public DDLRecord saveStagedModel(DDLRecord ddlRecord) throws PortalException {
        return this._ddlRecordLocalService.updateDDLRecord(ddlRecord);
    }

    public DDLRecord updateStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    private DynamicQuery _getRecordSetDynamicQuery(int scope) {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDLRecord.class.getName());
        Class clazz = stagedModelDataHandler.getClass();
        DynamicQuery recordSetDynamicQuery = DynamicQueryFactoryUtil.forClass(DDLRecordSet.class, (String)"recordSet", (ClassLoader)clazz.getClassLoader());
        recordSetDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordSetId"));
        recordSetDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordSet.recordSetId", (String)"recordSetId"));
        Property scopeProperty = PropertyFactoryUtil.forName((String)"scope");
        recordSetDynamicQuery.add(scopeProperty.eq((Object)scope));
        return recordSetDynamicQuery;
    }

    private DynamicQuery _getRecordVersionDynamicQuery() {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDLRecord.class.getName());
        Class clazz = stagedModelDataHandler.getClass();
        DynamicQuery recordVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DDLRecordVersion.class, (String)"recordVersion", (ClassLoader)clazz.getClassLoader());
        recordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordId"));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        recordVersionDynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
        recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.version", (String)"version"));
        recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.recordId", (String)"recordId"));
        return recordVersionDynamicQuery;
    }
}

