/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exportimport.data.handler;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class DDLRecordSetStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecordSet> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecordSet.class.getName()};
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet)")
    private StagedModelRepository<DDLRecordSet> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecordSet recordSet) {
        return recordSet.getNameCurrentValue();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        this._exportReferencedStagedModel(ddmStructure, portletDataContext, recordSet);
        List ddmTemplates = ddmStructure.getTemplates();
        Element recordSetElement = portletDataContext.getExportDataElement((ClassedModel)recordSet);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, (StagedModel)ddmTemplate, (String)"strong");
        }
        if (recordSet.getScope() == 2) {
            this._exportRecordSetSettings(portletDataContext, recordSet, recordSetElement);
        }
        portletDataContext.addClassedModel(recordSetElement, ExportImportPathUtil.getModelPath((StagedModel)recordSet), (ClassedModel)recordSet);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long recordSetId) throws Exception {
        DDLRecordSet existingRecordSet = (DDLRecordSet)this.fetchMissingReference(uuid, groupId);
        if (existingRecordSet == null) {
            return;
        }
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        recordSetIds.put(recordSetId, existingRecordSet.getRecordSetId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)recordSet.getDDMStructureId(), (long)recordSet.getDDMStructureId());
        DDLRecordSet importedRecordSet = (DDLRecordSet)recordSet.clone();
        importedRecordSet.setGroupId(portletDataContext.getScopeGroupId());
        importedRecordSet.setDDMStructureId(ddmStructureId);
        DDLRecordSet existingRecordSet = (DDLRecordSet)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(recordSet.getUuid(), portletDataContext.getScopeGroupId());
        if (existingRecordSet == null || !portletDataContext.isDataStrategyMirror()) {
            importedRecordSet = (DDLRecordSet)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedRecordSet);
        } else {
            importedRecordSet.setMvccVersion(existingRecordSet.getMvccVersion());
            importedRecordSet.setRecordSetId(existingRecordSet.getRecordSetId());
            importedRecordSet = (DDLRecordSet)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedRecordSet);
        }
        if (recordSet.getScope() == 2) {
            Element recordSetElement = portletDataContext.getImportDataElement((StagedModel)recordSet);
            DDMFormValues settingsDDMFormValues = this._getImportRecordSetSettings(portletDataContext, recordSetElement);
            this._ddlRecordSetLocalService.updateRecordSet(importedRecordSet.getRecordSetId(), settingsDDMFormValues);
        }
        portletDataContext.importClassedModel((ClassedModel)recordSet, (ClassedModel)importedRecordSet);
    }

    protected StagedModelRepository<DDLRecordSet> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    private void _exportRecordSetSettings(PortletDataContext portletDataContext, DDLRecordSet recordSet, Element recordSetElement) {
        String settingsDDMFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)recordSet, (String)"settings-ddm-form-values.json");
        recordSetElement.addAttribute("settings-ddm-form-values-path", settingsDDMFormValuesPath);
        portletDataContext.addZipEntry(settingsDDMFormValuesPath, recordSet.getSettings());
    }

    private void _exportReferencedStagedModel(DDMStructure ddmStructure, PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        if (!this._exportImportHelper.isAlwaysIncludeReference(portletDataContext, (StagedModel)ddmStructure)) {
            portletDataContext.addReferenceElement((ClassedModel)recordSet, portletDataContext.getExportDataElement((ClassedModel)recordSet), (ClassedModel)ddmStructure, "dependency", true);
            return;
        }
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)ExportImportClassedModelUtil.getClassName((ClassedModel)ddmStructure));
        if (stagedModelDataHandler == null) {
            return;
        }
        stagedModelDataHandler.exportStagedModel(portletDataContext, (StagedModel)ddmStructure);
        portletDataContext.addReferenceElement((ClassedModel)recordSet, portletDataContext.getExportDataElement((ClassedModel)recordSet), (ClassedModel)ddmStructure, "strong", false);
    }

    private DDMFormValues _getImportRecordSetSettings(PortletDataContext portletDataContext, Element recordSetElement) throws Exception {
        DDMForm ddmForm = DDMFormFactory.create(DDLRecordSetSettings.class);
        String settingsDDMFormValuesPath = recordSetElement.attributeValue("settings-ddm-form-values-path");
        String serializedSettingsDDMFormValues = portletDataContext.getZipEntryAsString(settingsDDMFormValuesPath);
        return this.deserialize(serializedSettingsDDMFormValues, ddmForm);
    }
}

