/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.lists.service.base;

import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionServiceUtil;
import com.liferay.dynamic.data.lists.service.persistence.DDLRecordSetVersionPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the ddl record set version remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.dynamic.data.lists.service.impl.DDLRecordSetVersionServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.dynamic.data.lists.service.impl.DDLRecordSetVersionServiceImpl
 * @generated
 */
public abstract class DDLRecordSetVersionServiceBaseImpl
	extends BaseServiceImpl
	implements DDLRecordSetVersionService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>DDLRecordSetVersionService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>DDLRecordSetVersionServiceUtil</code>.
	 */

	/**
	 * Returns the ddl record set version local service.
	 *
	 * @return the ddl record set version local service
	 */
	public
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			getDDLRecordSetVersionLocalService() {

		return ddlRecordSetVersionLocalService;
	}

	/**
	 * Sets the ddl record set version local service.
	 *
	 * @param ddlRecordSetVersionLocalService the ddl record set version local service
	 */
	public void setDDLRecordSetVersionLocalService(
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			ddlRecordSetVersionLocalService) {

		this.ddlRecordSetVersionLocalService = ddlRecordSetVersionLocalService;
	}

	/**
	 * Returns the ddl record set version remote service.
	 *
	 * @return the ddl record set version remote service
	 */
	public DDLRecordSetVersionService getDDLRecordSetVersionService() {
		return ddlRecordSetVersionService;
	}

	/**
	 * Sets the ddl record set version remote service.
	 *
	 * @param ddlRecordSetVersionService the ddl record set version remote service
	 */
	public void setDDLRecordSetVersionService(
		DDLRecordSetVersionService ddlRecordSetVersionService) {

		this.ddlRecordSetVersionService = ddlRecordSetVersionService;
	}

	/**
	 * Returns the ddl record set version persistence.
	 *
	 * @return the ddl record set version persistence
	 */
	public DDLRecordSetVersionPersistence getDDLRecordSetVersionPersistence() {
		return ddlRecordSetVersionPersistence;
	}

	/**
	 * Sets the ddl record set version persistence.
	 *
	 * @param ddlRecordSetVersionPersistence the ddl record set version persistence
	 */
	public void setDDLRecordSetVersionPersistence(
		DDLRecordSetVersionPersistence ddlRecordSetVersionPersistence) {

		this.ddlRecordSetVersionPersistence = ddlRecordSetVersionPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		DDLRecordSetVersionServiceUtil.setService(ddlRecordSetVersionService);
	}

	public void destroy() {
		DDLRecordSetVersionServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return DDLRecordSetVersionService.class.getName();
	}

	protected Class<?> getModelClass() {
		return DDLRecordSetVersion.class;
	}

	protected String getModelClassName() {
		return DDLRecordSetVersion.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource = ddlRecordSetVersionPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService.class
	)
	protected
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			ddlRecordSetVersionLocalService;

	@BeanReference(type = DDLRecordSetVersionService.class)
	protected DDLRecordSetVersionService ddlRecordSetVersionService;

	@BeanReference(type = DDLRecordSetVersionPersistence.class)
	protected DDLRecordSetVersionPersistence ddlRecordSetVersionPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		DDLRecordSetVersionServiceBaseImpl.class);

}