/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.versioning.VersionPurger;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, service={VersionPurger.class})
public class VersionPurgerImpl
implements VersionPurger {
    private DLConfiguration _dlConfiguration;

    public Collection<FileVersion> getToPurgeFileVersions(FileEntry fileEntry) {
        int maximumNumberOfVersions = this._dlConfiguration.maximumNumberOfVersions();
        if (maximumNumberOfVersions <= 0) {
            return Collections.emptyList();
        }
        int status = -1;
        int numberOfVersions = fileEntry.getFileVersionsCount(status);
        if (numberOfVersions > maximumNumberOfVersions) {
            List fileVersions = fileEntry.getFileVersions(status);
            int numberOfVersionsToPurge = numberOfVersions - maximumNumberOfVersions;
            return fileVersions.subList(fileVersions.size() - numberOfVersionsToPurge, fileVersions.size());
        }
        return Collections.emptyList();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }
}

