/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class ImageDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final long _REPOSITORY_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(ImageDLStoreConvertProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ImageLocalService _imageLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, true);
    }

    private ActionableDynamicQuery _getActionableDynamicQuery(long companyId, Store sourceStore, Store targetStore, boolean delete) {
        ActionableDynamicQuery actionableDynamicQuery = this._imageLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId)));
        actionableDynamicQuery.setPerformActionMethod(image -> {
            String fileName = image.getImageId() + "." + image.getType();
            try {
                this.transferFile(sourceStore, targetStore, image.getCompanyId(), 0L, fileName, "1.0", delete);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to migrate " + fileName), (Throwable)exception);
            }
        });
        return actionableDynamicQuery;
    }

    private long _getCount(long companyId) {
        DynamicQuery dynamicQuery = this._imageLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
        return this._imageLocalService.dynamicQueryCount(dynamicQuery);
    }

    private void _transfer(Store sourceStore, Store targetStore, boolean delete) throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> {
            MaintenanceUtil.appendStatus((String)String.format("Migrating %d images for company %d", this._getCount((long)companyId), companyId));
            ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery((long)companyId, sourceStore, targetStore, delete);
            actionableDynamicQuery.performActions();
        });
    }
}

