/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.changeset.service.impl;

import com.liferay.changeset.exception.NoSuchEntryException;
import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.base.ChangesetEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.changeset.model.ChangesetEntry"}, service={AopService.class})
public class ChangesetEntryLocalServiceImpl
extends ChangesetEntryLocalServiceBaseImpl {
    public ChangesetEntry addChangesetEntry(long userId, long changesetCollectionId, long classNameId, long classPK) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        ChangesetCollection changesetCollection = this.changesetCollectionPersistence.fetchByPrimaryKey(changesetCollectionId);
        long changesetEntryId = this.counterLocalService.increment();
        ChangesetEntry changesetEntry = this.changesetEntryPersistence.create(changesetEntryId);
        changesetEntry.setGroupId(changesetCollection.getGroupId());
        changesetEntry.setCompanyId(user.getCompanyId());
        changesetEntry.setUserId(user.getUserId());
        changesetEntry.setUserName(user.getFullName());
        changesetEntry.setChangesetCollectionId(changesetCollectionId);
        changesetEntry.setClassNameId(classNameId);
        changesetEntry.setClassPK(classPK);
        return (ChangesetEntry)this.changesetEntryPersistence.update((BaseModel)changesetEntry);
    }

    public void deleteChangesetEntries(long changesetCollectionId) {
        this.changesetEntryPersistence.removeByChangesetCollectionId(changesetCollectionId);
    }

    public void deleteChangesetEntries(Set<Long> changesetEntryIds) {
        if (SetUtil.isEmpty(changesetEntryIds)) {
            return;
        }
        for (long changesetEntryId : changesetEntryIds) {
            ChangesetEntry changesetEntry = this.changesetEntryPersistence.fetchByPrimaryKey(changesetEntryId);
            if (changesetEntry == null) continue;
            this.changesetEntryPersistence.remove((BaseModel)changesetEntry);
        }
    }

    public void deleteEntry(long changesetId, long classNameId, long classPK) {
        ChangesetEntry changesetEntry = this.changesetEntryLocalService.fetchChangesetEntry(changesetId, classNameId, classPK);
        if (changesetEntry != null) {
            this.changesetEntryLocalService.deleteChangesetEntry(changesetEntry);
        }
    }

    public ChangesetEntry fetchChangesetEntry(long changesetCollectionId, long classNameId, long classPK) {
        return this.changesetEntryPersistence.fetchByC_C_C(changesetCollectionId, classNameId, classPK);
    }

    public ChangesetEntry fetchOrAddChangesetEntry(long changesetCollectionId, long classNameId, long classPK) throws PortalException {
        ChangesetEntry changesetEntry = this.changesetEntryLocalService.fetchChangesetEntry(changesetCollectionId, classNameId, classPK);
        if (changesetEntry != null) {
            return changesetEntry;
        }
        ChangesetCollection changesetCollection = this.changesetCollectionPersistence.findByPrimaryKey(changesetCollectionId);
        User user = this.userLocalService.getDefaultUser(changesetCollection.getCompanyId());
        return this.changesetEntryLocalService.addChangesetEntry(user.getUserId(), changesetCollectionId, classNameId, classPK);
    }

    public List<ChangesetEntry> getChangesetEntries(long changesetCollectionId, long classNameId) {
        return this.changesetEntryPersistence.findByC_C(changesetCollectionId, classNameId);
    }

    public long getChangesetEntriesCount(long changesetCollectionId) {
        return this.changesetEntryPersistence.countByChangesetCollectionId(changesetCollectionId);
    }

    public long getChangesetEntriesCount(long changesetCollectionId, long classNameId) {
        return this.changesetEntryPersistence.countByC_C(changesetCollectionId, classNameId);
    }

    public long getChangesetEntriesCount(long changesetCollectionId, long classNameId, Set<Long> classPKs) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"changesetCollectionId", (Object)changesetCollectionId));
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)classNameId));
        if (!SetUtil.isNotEmpty(classPKs)) {
            return 0L;
        }
        dynamicQuery.add(RestrictionsFactoryUtil.in((String)"classPK", classPKs));
        return this.dynamicQueryCount(dynamicQuery);
    }

    public ChangesetEntry getChangesetEntry(long changesetCollectionId, long classNameId, long classPK) throws NoSuchEntryException {
        return this.changesetEntryPersistence.findByC_C_C(changesetCollectionId, classNameId, classPK);
    }
}

