/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calevent.importer.internal.verify;

import com.liferay.asset.kernel.exception.NoSuchVocabularyException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.calendar.exception.NoSuchBookingException;
import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.model.CalendarResource;
import com.liferay.calendar.notification.NotificationType;
import com.liferay.calendar.recurrence.Frequency;
import com.liferay.calendar.recurrence.PositionalWeekday;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.recurrence.RecurrenceSerializer;
import com.liferay.calendar.recurrence.Weekday;
import com.liferay.calendar.service.CalendarBookingLocalService;
import com.liferay.calendar.service.CalendarResourceLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jabsorb.JSONSerializer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.calevent.importer"}, service={VerifyProcess.class})
public class CalEventImporterVerifyProcess
extends VerifyProcess {
    private static final String _ASSET_VOCABULARY_NAME = "Calendar Event Types";
    private static final String _CLASS_NAME = "com.liferay.portlet.calendar.model.CalEvent";
    private static final int _REMIND_BY_NONE = 0;
    private static final Log _log = LogFactoryUtil.getLog(CalEventImporterVerifyProcess.class);
    private static final Map<Integer, Frequency> _frequencies = new HashMap<Integer, Frequency>(){
        {
            this.put(3, Frequency.DAILY);
            this.put(5, Frequency.MONTHLY);
            this.put(4, Frequency.WEEKLY);
            this.put(6, Frequency.YEARLY);
        }
    };
    private static final Map<Integer, Weekday> _weekdays = new HashMap<Integer, Weekday>(){
        {
            this.put(6, Weekday.FRIDAY);
            this.put(2, Weekday.MONDAY);
            this.put(7, Weekday.SATURDAY);
            this.put(1, Weekday.SUNDAY);
            this.put(5, Weekday.THURSDAY);
            this.put(3, Weekday.TUESDAY);
            this.put(4, Weekday.WEDNESDAY);
        }
    };
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private CalendarBookingLocalService _calendarBookingLocalService;
    @Reference
    private CalendarResourceLocalService _calendarResourceLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private JSONSerializer _jsonSerializer;
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    protected void doVerify() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.importCalEvents();
        }
    }

    protected void importCalEvents() throws Exception {
        if (!this.hasTable("CalEvent")) {
            return;
        }
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(6);
            sb.append("select uuid_, eventId, groupId, companyId, userId, ");
            sb.append("userName, createDate, modifiedDate, title, ");
            sb.append("description, location, startDate, endDate, ");
            sb.append("durationHour, durationMinute, allDay, type_, ");
            sb.append("repeating, recurrence, remindBy, firstReminder, ");
            sb.append("secondReminder from CalEvent");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String uuid = rs.getString("uuid_");
                    long eventId = rs.getLong("eventId");
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    long userId = rs.getLong("userId");
                    String userName = rs.getString("userName");
                    Timestamp createDate = rs.getTimestamp("createDate");
                    Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                    String title = rs.getString("title");
                    String description = rs.getString("description");
                    String location = rs.getString("location");
                    Timestamp startDate = rs.getTimestamp("startDate");
                    int durationHour = rs.getInt("durationHour");
                    int durationMinute = rs.getInt("durationMinute");
                    boolean allDay = rs.getBoolean("allDay");
                    String type = rs.getString("type_");
                    String recurrence = rs.getString("recurrence");
                    int remindBy = rs.getInt("remindBy");
                    int firstReminder = rs.getInt("firstReminder");
                    int secondReminder = rs.getInt("secondReminder");
                    CalendarBooking calendarBooking = this._importCalEvent(uuid, eventId, groupId, companyId, userId, userName, createDate, modifiedDate, title, description, location, startDate, durationHour, durationMinute, allDay, type, recurrence, remindBy, firstReminder, secondReminder);
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("CalendarBooking: " + calendarBooking + " imported sucessfully."));
                }
            }
        }
    }

    private void _addAssetEntry(long entryId, long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long classNameId, long classPK, String classUuid, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, double priority, int viewCount) {
        AssetEntry assetEntry = this._assetEntryLocalService.createAssetEntry(entryId);
        assetEntry.setGroupId(groupId);
        assetEntry.setCompanyId(companyId);
        assetEntry.setUserId(userId);
        assetEntry.setUserName(userName);
        assetEntry.setCreateDate(createDate);
        assetEntry.setModifiedDate(modifiedDate);
        assetEntry.setClassNameId(classNameId);
        assetEntry.setClassPK(classPK);
        assetEntry.setClassUuid(classUuid);
        assetEntry.setVisible(visible);
        assetEntry.setStartDate(startDate);
        assetEntry.setEndDate(endDate);
        assetEntry.setPublishDate(publishDate);
        assetEntry.setExpirationDate(expirationDate);
        assetEntry.setMimeType(mimeType);
        assetEntry.setTitle(title);
        assetEntry.setDescription(description);
        assetEntry.setSummary(summary);
        assetEntry.setUrl(url);
        assetEntry.setLayoutUuid(layoutUuid);
        assetEntry.setHeight(height);
        assetEntry.setWidth(width);
        assetEntry.setPriority(priority);
        assetEntry.setViewCount(viewCount);
        this._assetEntryLocalService.updateAssetEntry(assetEntry);
    }

    private void _addAssetLink(long linkId, long companyId, long userId, String userName, Date createDate, long entryId1, long entryId2, int type, int weight) {
        AssetLink assetLink = this._assetLinkLocalService.createAssetLink(linkId);
        assetLink.setCompanyId(companyId);
        assetLink.setUserId(userId);
        assetLink.setUserName(userName);
        assetLink.setCreateDate(createDate);
        assetLink.setEntryId1(entryId1);
        assetLink.setEntryId2(entryId2);
        assetLink.setType(type);
        assetLink.setWeight(weight);
        this._assetLinkLocalService.updateAssetLink(assetLink);
    }

    private CalendarBooking _addCalendarBooking(String uuid, long calendarBookingId, long companyId, long groupId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long calendarId, long calendarResourceId, String title, String description, String location, long startTime, long endTime, boolean allDay, String recurrence, int firstReminder, NotificationType firstReminderType, int secondReminder, NotificationType secondReminderType) {
        CalendarBooking calendarBooking = this._calendarBookingLocalService.createCalendarBooking(calendarBookingId);
        calendarBooking.setUuid(uuid);
        calendarBooking.setGroupId(groupId);
        calendarBooking.setCompanyId(companyId);
        calendarBooking.setUserId(userId);
        calendarBooking.setUserName(userName);
        calendarBooking.setCreateDate((Date)createDate);
        calendarBooking.setModifiedDate((Date)modifiedDate);
        calendarBooking.setCalendarId(calendarId);
        calendarBooking.setCalendarResourceId(calendarResourceId);
        calendarBooking.setParentCalendarBookingId(calendarBookingId);
        calendarBooking.setVEventUid(uuid);
        calendarBooking.setTitle(title);
        calendarBooking.setDescription(description);
        calendarBooking.setLocation(location);
        calendarBooking.setStartTime(startTime);
        calendarBooking.setEndTime(endTime);
        calendarBooking.setAllDay(allDay);
        calendarBooking.setRecurrence(recurrence);
        calendarBooking.setFirstReminder((long)firstReminder);
        calendarBooking.setFirstReminderType(firstReminderType.toString());
        calendarBooking.setSecondReminder((long)secondReminder);
        calendarBooking.setSecondReminderType(secondReminderType.toString());
        calendarBooking.setStatus(0);
        calendarBooking.setStatusByUserId(userId);
        calendarBooking.setStatusByUserName(userName);
        calendarBooking.setStatusDate((Date)createDate);
        return this._calendarBookingLocalService.updateCalendarBooking(calendarBooking);
    }

    private void _addMBDiscussion(String uuid, long discussionId, long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long classNameId, long classPK, long threadId) {
        MBDiscussion mbDiscussion = this._mbDiscussionLocalService.createMBDiscussion(discussionId);
        mbDiscussion.setUuid(uuid);
        mbDiscussion.setGroupId(groupId);
        mbDiscussion.setCompanyId(companyId);
        mbDiscussion.setUserId(userId);
        mbDiscussion.setUserName(userName);
        mbDiscussion.setCreateDate(createDate);
        mbDiscussion.setModifiedDate(modifiedDate);
        mbDiscussion.setClassNameId(classNameId);
        mbDiscussion.setClassPK(classPK);
        mbDiscussion.setThreadId(threadId);
        this._mbDiscussionLocalService.updateMBDiscussion(mbDiscussion);
    }

    private void _addMBMessage(String uuid, long messageId, long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long classNameId, long classPK, long categoryId, long threadId, long rootMessageId, long parentMessageId, String subject, String body, String format, boolean anonymous, double priority, boolean allowPingbacks, boolean answer, int status, long statusByUserId, String statusByUserName, Date statusDate, Map<Long, Long> mbMessageIds) throws PortalException {
        if (parentMessageId == 0L) {
            rootMessageId = messageId;
        } else {
            rootMessageId = this._importMBMessage(rootMessageId, threadId, classPK, mbMessageIds);
            parentMessageId = this._importMBMessage(parentMessageId, threadId, classPK, mbMessageIds);
        }
        MBMessage mbMessage = this._mbMessageLocalService.createMBMessage(messageId);
        mbMessage.setUuid(uuid);
        mbMessage.setGroupId(groupId);
        mbMessage.setCompanyId(companyId);
        mbMessage.setUserId(userId);
        mbMessage.setUserName(userName);
        mbMessage.setCreateDate(createDate);
        mbMessage.setModifiedDate(modifiedDate);
        mbMessage.setClassNameId(classNameId);
        mbMessage.setClassPK(classPK);
        mbMessage.setCategoryId(categoryId);
        mbMessage.setThreadId(threadId);
        mbMessage.setRootMessageId(rootMessageId);
        mbMessage.setParentMessageId(parentMessageId);
        mbMessage.setSubject(subject);
        mbMessage.setBody(body);
        mbMessage.setFormat(format);
        mbMessage.setAnonymous(anonymous);
        mbMessage.setPriority(priority);
        mbMessage.setAllowPingbacks(allowPingbacks);
        mbMessage.setAnswer(answer);
        mbMessage.setStatus(status);
        mbMessage.setStatusByUserId(statusByUserId);
        mbMessage.setStatusByUserName(statusByUserName);
        mbMessage.setStatusDate(statusDate);
        this._mbMessageLocalService.updateMBMessage(mbMessage);
    }

    private void _addMBThread(String uuid, long threadId, long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long categoryId, long rootMessageId, long rootMessageUserId, String title, int messageCount, int viewCount, long lastPostByUserId, Date lastPostDate, double priority, boolean question, int status, long statusByUserId, String statusByUserName, Date statusDate) {
        MBThread mbThread = this._mbThreadLocalService.createMBThread(threadId);
        mbThread.setUuid(uuid);
        mbThread.setGroupId(groupId);
        mbThread.setCompanyId(companyId);
        mbThread.setUserId(userId);
        mbThread.setUserName(userName);
        mbThread.setCreateDate(createDate);
        mbThread.setModifiedDate(modifiedDate);
        mbThread.setCategoryId(categoryId);
        mbThread.setRootMessageId(rootMessageId);
        mbThread.setRootMessageUserId(rootMessageUserId);
        mbThread.setTitle(title);
        mbThread.setMessageCount(messageCount);
        mbThread.setViewCount(viewCount);
        mbThread.setLastPostByUserId(lastPostByUserId);
        mbThread.setLastPostDate(lastPostDate);
        mbThread.setPriority(priority);
        mbThread.setQuestion(question);
        mbThread.setStatus(status);
        mbThread.setStatusByUserId(statusByUserId);
        mbThread.setStatusByUserName(statusByUserName);
        mbThread.setStatusDate(statusDate);
        this._mbThreadLocalService.updateMBThread(mbThread);
    }

    private RatingsEntry _addRatingsEntry(long entryId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, String className, long classPK, double score) {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        RatingsEntry ratingsEntry = this._ratingsEntryLocalService.createRatingsEntry(entryId);
        ratingsEntry.setCompanyId(companyId);
        ratingsEntry.setUserId(userId);
        ratingsEntry.setUserName(userName);
        ratingsEntry.setCreateDate(createDate);
        ratingsEntry.setModifiedDate(modifiedDate);
        ratingsEntry.setClassNameId(classNameId);
        ratingsEntry.setClassPK(classPK);
        ratingsEntry.setScore(score);
        return this._ratingsEntryLocalService.updateRatingsEntry(ratingsEntry);
    }

    private RatingsStats _addRatingsStats(long statsId, String className, long classPK, int totalEntries, double totalScore, double averageScore) {
        RatingsStats ratingsStats = this._ratingsStatsLocalService.createRatingsStats(statsId);
        ratingsStats.setClassNameId(this._classNameLocalService.getClassNameId(className));
        ratingsStats.setClassPK(classPK);
        ratingsStats.setTotalEntries(totalEntries);
        ratingsStats.setTotalScore(totalScore);
        ratingsStats.setAverageScore(averageScore);
        return this._ratingsStatsLocalService.updateRatingsStats(ratingsStats);
    }

    private void _addSocialActivity(long activityId, long groupId, long companyId, long userId, long createDate, long mirrorActivityId, long classNameId, long classPK, int type, String extraData, long receiverUserId) {
        SocialActivity socialActivity = this._socialActivityLocalService.createSocialActivity(activityId);
        socialActivity.setGroupId(groupId);
        socialActivity.setCompanyId(companyId);
        socialActivity.setUserId(userId);
        socialActivity.setCreateDate(createDate);
        socialActivity.setMirrorActivityId(mirrorActivityId);
        socialActivity.setClassNameId(classNameId);
        socialActivity.setClassPK(classPK);
        socialActivity.setType(type);
        socialActivity.setExtraData(extraData);
        socialActivity.setReceiverUserId(receiverUserId);
        this._socialActivityLocalService.updateSocialActivity(socialActivity);
    }

    private void _addSubscription(long subscriptionId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long classNameId, long classPK, String frequency) {
        Subscription subscription = this._subscriptionLocalService.createSubscription(subscriptionId);
        subscription.setCompanyId(companyId);
        subscription.setUserId(userId);
        subscription.setUserName(userName);
        subscription.setCreateDate(createDate);
        subscription.setModifiedDate(modifiedDate);
        subscription.setClassNameId(classNameId);
        subscription.setClassPK(classPK);
        subscription.setFrequency(frequency);
        this._subscriptionLocalService.updateSubscription(subscription);
    }

    private String _convertRecurrence(String originalRecurrence) throws Exception {
        if (Validator.isNull((String)originalRecurrence)) {
            return null;
        }
        TZSRecurrence tzsRecurrence = null;
        try {
            tzsRecurrence = (TZSRecurrence)JSONFactoryUtil.deserialize((String)originalRecurrence);
        }
        catch (IllegalStateException illegalStateException) {
            JSONSerializer jsonSerializer = this._getJSONSerializer();
            tzsRecurrence = (TZSRecurrence)jsonSerializer.fromJSON(originalRecurrence);
        }
        if (tzsRecurrence == null) {
            return null;
        }
        Recurrence recurrence = new Recurrence();
        Frequency frequency = _frequencies.get(tzsRecurrence.getFrequency());
        int interval = tzsRecurrence.getInterval();
        ArrayList<PositionalWeekday> positionalWeekdays = new ArrayList<PositionalWeekday>();
        if (frequency == Frequency.DAILY && interval == 0) {
            frequency = Frequency.WEEKLY;
            interval = 1;
            positionalWeekdays.add(new PositionalWeekday(Weekday.MONDAY, 0));
            positionalWeekdays.add(new PositionalWeekday(Weekday.TUESDAY, 0));
            positionalWeekdays.add(new PositionalWeekday(Weekday.WEDNESDAY, 0));
            positionalWeekdays.add(new PositionalWeekday(Weekday.THURSDAY, 0));
            positionalWeekdays.add(new PositionalWeekday(Weekday.FRIDAY, 0));
        } else {
            int[] months;
            DayAndPosition[] dayAndPositions = tzsRecurrence.getByDay();
            if (dayAndPositions != null) {
                for (DayAndPosition dayAndPosition : dayAndPositions) {
                    Weekday weekday = _weekdays.get(dayAndPosition.getDayOfWeek());
                    PositionalWeekday positionalWeekday = new PositionalWeekday(weekday, dayAndPosition.getDayPosition());
                    positionalWeekdays.add(positionalWeekday);
                }
            }
            if (ArrayUtil.isNotEmpty((int[])(months = tzsRecurrence.getByMonth()))) {
                ArrayList<Integer> monthsList = new ArrayList<Integer>();
                for (int month : months) {
                    monthsList.add(month);
                }
                recurrence.setMonths(monthsList);
            }
        }
        recurrence.setInterval(interval);
        recurrence.setFrequency(frequency);
        recurrence.setPositionalWeekdays(positionalWeekdays);
        Calendar untilJCalendar = tzsRecurrence.getUntil();
        int ocurrence = tzsRecurrence.getOccurrence();
        if (untilJCalendar != null) {
            recurrence.setUntilJCalendar(untilJCalendar);
        } else if (ocurrence > 0) {
            recurrence.setCount(ocurrence);
        }
        return RecurrenceSerializer.serialize((Recurrence)recurrence);
    }

    private String[] _getActionIds(ResourcePermission resourcePermission, String oldClassName, List<String> modelResourceActions) {
        ArrayList<String> actionIds = new ArrayList<String>();
        List resourceActions = this._resourceActionLocalService.getResourceActions(oldClassName);
        for (ResourceAction resourceAction : resourceActions) {
            if (!resourcePermission.hasAction(resourceAction) || !modelResourceActions.contains(resourceAction.getActionId())) continue;
            actionIds.add(resourceAction.getActionId());
        }
        return actionIds.toArray(new String[0]);
    }

    private AssetCategory _getAssetCategory(long userId, long companyId, long groupId, String name) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        User user = null;
        try {
            user = this._userLocalService.getUserById(companyId, userId);
        }
        catch (NoSuchUserException noSuchUserException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchUserException, (Throwable)noSuchUserException);
            }
            user = this._userLocalService.getDefaultUser(companyId);
            userId = user.getUserId();
        }
        serviceContext.setUserId(userId);
        AssetVocabulary assetVocabulary = null;
        try {
            assetVocabulary = this._assetVocabularyLocalService.getGroupVocabulary(groupId, _ASSET_VOCABULARY_NAME);
        }
        catch (NoSuchVocabularyException noSuchVocabularyException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchVocabularyException, (Throwable)noSuchVocabularyException);
            }
            assetVocabulary = this._assetVocabularyLocalService.addVocabulary(userId, groupId, _ASSET_VOCABULARY_NAME, serviceContext);
        }
        List assetCategories = this._assetCategoryLocalService.getVocabularyRootCategories(assetVocabulary.getVocabularyId(), -1, -1, null);
        for (AssetCategory assetCategory : assetCategories) {
            if (!name.equals(assetCategory.getName())) continue;
            return assetCategory;
        }
        return this._assetCategoryLocalService.addCategory(userId, groupId, name, assetVocabulary.getVocabularyId(), serviceContext);
    }

    private CalendarResource _getCalendarResource(long companyId, long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        long userId = this._userLocalService.getDefaultUserId(companyId);
        serviceContext.setUserId(userId);
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.isUser()) {
            userId = group.getClassPK();
            CalendarResource calendarResource = this._calendarResourceLocalService.fetchCalendarResource(this._classNameLocalService.getClassNameId(User.class), userId);
            if (calendarResource != null) {
                return calendarResource;
            }
            User user = this._userLocalService.getUser(userId);
            Group userGroup = null;
            String userName = user.getFullName();
            if (user.isDefaultUser()) {
                userGroup = this._groupLocalService.getGroup(serviceContext.getCompanyId(), "Guest");
                userName = "Guest";
            } else {
                userGroup = this._groupLocalService.getUserGroup(serviceContext.getCompanyId(), userId);
            }
            HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)userName).build();
            HashMap descriptionMap = new HashMap();
            return this._calendarResourceLocalService.addCalendarResource(userId, userGroup.getGroupId(), this._classNameLocalService.getClassNameId(User.class), userId, null, null, LocalizationUtil.populateLocalizationMap((Map)nameMap, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), (long)groupId), descriptionMap, true, serviceContext);
        }
        CalendarResource calendarResource = this._calendarResourceLocalService.fetchCalendarResource(this._classNameLocalService.getClassNameId(Group.class), groupId);
        if (calendarResource != null) {
            return calendarResource;
        }
        userId = group.getCreatorUserId();
        User user = this._userLocalService.fetchUserById(userId);
        if (user == null || user.isDefaultUser()) {
            Role role = this._roleLocalService.getRole(group.getCompanyId(), "Administrator");
            long[] userIds = this._userLocalService.getRoleUserIds(role.getRoleId());
            userId = userIds[0];
        }
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)group.getDescriptiveName()).build();
        HashMap descriptionMap = new HashMap();
        return this._calendarResourceLocalService.addCalendarResource(userId, groupId, this._classNameLocalService.getClassNameId(Group.class), groupId, null, null, LocalizationUtil.populateLocalizationMap((Map)nameMap, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), (long)groupId), descriptionMap, true, serviceContext);
    }

    private JSONSerializer _getJSONSerializer() throws Exception {
        if (this._jsonSerializer == null) {
            this._jsonSerializer = new JSONSerializer();
            this._jsonSerializer.registerDefaultSerializers();
        }
        return this._jsonSerializer;
    }

    private void _importAssetLink(AssetLink assetLink, long oldEntryId, long newEntryId) throws Exception {
        AssetEntry linkedAssetEntry;
        long entryId1 = 0L;
        long entryId2 = 0L;
        if (assetLink.getEntryId1() == oldEntryId) {
            entryId1 = newEntryId;
            entryId2 = assetLink.getEntryId2();
            linkedAssetEntry = this._assetEntryLocalService.fetchAssetEntry(entryId2);
        } else {
            entryId1 = assetLink.getEntryId1();
            entryId2 = newEntryId;
            linkedAssetEntry = this._assetEntryLocalService.fetchAssetEntry(entryId2);
        }
        if (linkedAssetEntry.getClassNameId() == this._classNameLocalService.getClassNameId(_CLASS_NAME)) {
            CalendarBooking calendarBooking = this._importCalEvent(linkedAssetEntry.getClassPK());
            CalendarResource calendarResource = this._getCalendarResource(calendarBooking.getCompanyId(), calendarBooking.getGroupId());
            linkedAssetEntry = this._assetEntryLocalService.getEntry(calendarResource.getGroupId(), calendarBooking.getUuid());
            if (assetLink.getEntryId1() == oldEntryId) {
                entryId2 = linkedAssetEntry.getEntryId();
            } else {
                entryId1 = linkedAssetEntry.getEntryId();
            }
            if (this._isAssetLinkImported(entryId1, entryId2, assetLink.getType())) {
                return;
            }
        }
        long linkId = this._counterLocalService.increment();
        this._addAssetLink(linkId, assetLink.getCompanyId(), assetLink.getUserId(), assetLink.getUserName(), assetLink.getCreateDate(), entryId1, entryId2, assetLink.getType(), assetLink.getWeight());
    }

    private void _importAssets(String uuid, long companyId, long groupId, long userId, String type, long eventId, long calendarBookingId) throws Exception {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(_CLASS_NAME, eventId);
        if (assetEntry == null) {
            return;
        }
        long entryId = this._counterLocalService.increment();
        this._addAssetEntry(entryId, assetEntry.getGroupId(), assetEntry.getCompanyId(), assetEntry.getUserId(), assetEntry.getUserName(), assetEntry.getCreateDate(), assetEntry.getModifiedDate(), this._classNameLocalService.getClassNameId(CalendarBooking.class.getName()), calendarBookingId, uuid, assetEntry.isVisible(), assetEntry.getStartDate(), assetEntry.getEndDate(), assetEntry.getPublishDate(), assetEntry.getExpirationDate(), assetEntry.getMimeType(), assetEntry.getTitle(), assetEntry.getDescription(), assetEntry.getSummary(), assetEntry.getUrl(), assetEntry.getLayoutUuid(), assetEntry.getHeight(), assetEntry.getWidth(), assetEntry.getPriority(), assetEntry.getViewCount());
        ArrayList<AssetCategory> assetCategories = new ArrayList<AssetCategory>();
        assetCategories.addAll(assetEntry.getCategories());
        if (Validator.isNotNull((String)type)) {
            assetCategories.add(this._getAssetCategory(userId, companyId, groupId, type));
        }
        for (AssetCategory assetCategory : assetCategories) {
            this._assetEntryLocalService.addAssetCategoryAssetEntry(assetCategory.getCategoryId(), entryId);
        }
        List assetLinks = this._assetLinkLocalService.getLinks(assetEntry.getEntryId());
        for (AssetLink assetLink : assetLinks) {
            this._importAssetLink(assetLink, assetEntry.getEntryId(), entryId);
        }
        List list = assetEntry.getTags();
        for (AssetTag assetTag : list) {
            this._assetEntryLocalService.addAssetTagAssetEntry(assetTag.getTagId(), entryId);
        }
    }

    private void _importCalendarBookingResourcePermission(ResourcePermission resourcePermission, long calendarBookingId, List<String> modelResourceActions) throws PortalException {
        CalendarBooking calendarBooking = this._calendarBookingLocalService.getCalendarBooking(calendarBookingId);
        String[] actionIds = this._getActionIds(resourcePermission, _CLASS_NAME, modelResourceActions);
        this._resourcePermissionLocalService.setResourcePermissions(calendarBooking.getCompanyId(), CalendarBooking.class.getName(), 4, String.valueOf(calendarBookingId), resourcePermission.getRoleId(), actionIds);
    }

    private void _importCalendarBookingResourcePermissions(long companyId, long eventId, long calendarBookingId) throws PortalException {
        List modelResourceActions = ResourceActionsUtil.getModelResourceActions((String)CalendarBooking.class.getName());
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, _CLASS_NAME, 4, String.valueOf(eventId));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this._importCalendarBookingResourcePermission(resourcePermission, calendarBookingId, modelResourceActions);
        }
    }

    private CalendarBooking _importCalEvent(long calEventId) throws Exception {
        Throwable throwable = null;
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            Throwable throwable2;
            PreparedStatement ps;
            block25: {
                CalendarBooking calendarBooking;
                block26: {
                    block27: {
                        StringBundler sb = new StringBundler(6);
                        sb.append("select uuid_, eventId, groupId, companyId, userId, ");
                        sb.append("userName, createDate, modifiedDate, title, ");
                        sb.append("description, location, startDate, endDate, ");
                        sb.append("durationHour, durationMinute, allDay, type_, ");
                        sb.append("repeating, recurrence, remindBy, firstReminder, ");
                        sb.append("secondReminder from CalEvent where eventId = ?");
                        ps = this.connection.prepareStatement(sb.toString());
                        throwable2 = null;
                        ps.setLong(1, calEventId);
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) break block25;
                        String uuid = rs.getString("uuid_");
                        long eventId = rs.getLong("eventId");
                        long groupId = rs.getLong("groupId");
                        long companyId = rs.getLong("companyId");
                        long userId = rs.getLong("userId");
                        String userName = rs.getString("userName");
                        Timestamp createDate = rs.getTimestamp("createDate");
                        Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                        String title = rs.getString("title");
                        String description = rs.getString("description");
                        String location = rs.getString("location");
                        Timestamp startDate = rs.getTimestamp("startDate");
                        int durationHour = rs.getInt("durationHour");
                        int durationMinute = rs.getInt("durationMinute");
                        boolean allDay = rs.getBoolean("allDay");
                        String type = rs.getString("type_");
                        String recurrence = rs.getString("recurrence");
                        int remindBy = rs.getInt("remindBy");
                        int firstReminder = rs.getInt("firstReminder");
                        int secondReminder = rs.getInt("secondReminder");
                        calendarBooking = this._importCalEvent(uuid, eventId, groupId, companyId, userId, userName, createDate, modifiedDate, title, description, location, startDate, durationHour, durationMinute, allDay, type, recurrence, remindBy, firstReminder, secondReminder);
                        if (ps == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    ps.close();
                }
                return calendarBooking;
            }
            try {
                try {
                    try {
                        throw new NoSuchBookingException();
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (ps != null) {
                        if (throwable2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ps.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private CalendarBooking _importCalEvent(String uuid, long eventId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, String title, String description, String location, Timestamp startDate, int durationHour, int durationMinute, boolean allDay, String type, String recurrence, int remindBy, int firstReminder, int secondReminder) throws Exception {
        CalendarResource calendarResource = this._getCalendarResource(companyId, groupId);
        CalendarBooking calendarBooking = this._calendarBookingLocalService.fetchCalendarBookingByUuidAndGroupId(uuid, calendarResource.getGroupId());
        if (calendarBooking != null) {
            return calendarBooking;
        }
        long calendarBookingId = this._counterLocalService.increment();
        long startTime = startDate.getTime();
        long endTime = startTime + (long)durationHour * 3600000L + (long)durationMinute * 60000L;
        if (allDay) {
            --endTime;
        }
        if (remindBy == 0) {
            firstReminder = 0;
            secondReminder = 0;
        }
        calendarBooking = this._addCalendarBooking(uuid, calendarBookingId, companyId, groupId, userId, userName, createDate, modifiedDate, calendarResource.getDefaultCalendarId(), calendarResource.getCalendarResourceId(), title, description, location, startTime, endTime, allDay, this._convertRecurrence(recurrence), firstReminder, NotificationType.EMAIL, secondReminder, NotificationType.EMAIL);
        this._importCalendarBookingResourcePermissions(companyId, eventId, calendarBookingId);
        this._importSubscriptions(companyId, eventId, calendarBookingId);
        this._importAssets(uuid, companyId, groupId, userId, type, eventId, calendarBookingId);
        this._importExpando(companyId, eventId, calendarBookingId);
        this._importMBDiscussion(eventId, calendarBookingId);
        this._importRatings(_CLASS_NAME, eventId, CalendarBooking.class.getName(), calendarBookingId);
        this._importSocialActivities(eventId, calendarBookingId);
        return calendarBooking;
    }

    private void _importExpando(long companyId, long eventId, long calendarBookingId) throws PortalException {
        long oldClassNameId = this._classNameLocalService.getClassNameId(_CLASS_NAME);
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, oldClassNameId, "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return;
        }
        ExpandoRow expandoRow = this._expandoRowLocalService.fetchRow(expandoTable.getTableId(), eventId);
        expandoRow.setClassPK(calendarBookingId);
        this._expandoRowLocalService.updateExpandoRow(expandoRow);
        long calendarBookingClassNameId = this._classNameLocalService.getClassNameId(CalendarBooking.class);
        expandoTable.setClassNameId(calendarBookingClassNameId);
        this._expandoTableLocalService.updateExpandoTable(expandoTable);
        List expandoValues = this._expandoValueLocalService.getRowValues(expandoRow.getRowId());
        for (ExpandoValue expandoValue : expandoValues) {
            expandoValue.setClassNameId(calendarBookingClassNameId);
            expandoValue.setClassPK(calendarBookingId);
            this._expandoValueLocalService.updateExpandoValue(expandoValue);
        }
    }

    private void _importMBDiscussion(long eventId, long calendarBookingId) throws PortalException {
        MBDiscussion mbDiscussion = this._mbDiscussionLocalService.fetchDiscussion(_CLASS_NAME, eventId);
        if (mbDiscussion == null) {
            return;
        }
        long threadId = this._importMBThread(mbDiscussion.getThreadId(), calendarBookingId);
        this._addMBDiscussion(PortalUUIDUtil.generate(), this._counterLocalService.increment(), mbDiscussion.getGroupId(), mbDiscussion.getCompanyId(), mbDiscussion.getUserId(), mbDiscussion.getUserName(), mbDiscussion.getCreateDate(), mbDiscussion.getModifiedDate(), this._classNameLocalService.getClassNameId(CalendarBooking.class.getName()), calendarBookingId, threadId);
    }

    private long _importMBMessage(long messageId, long threadId, long calendarBookingId, Map<Long, Long> mbMessageIds) throws PortalException {
        return this._importMBMessage(this._mbMessageLocalService.getMBMessage(messageId), threadId, calendarBookingId, mbMessageIds);
    }

    private long _importMBMessage(MBMessage mbMessage, long threadId, long calendarBookingId, Map<Long, Long> mbMessageIds) throws PortalException {
        Long messageId = mbMessageIds.get(mbMessage.getMessageId());
        if (messageId != null) {
            return messageId;
        }
        messageId = this._counterLocalService.increment();
        this._addMBMessage(PortalUUIDUtil.generate(), messageId, mbMessage.getGroupId(), mbMessage.getCompanyId(), mbMessage.getUserId(), mbMessage.getUserName(), mbMessage.getCreateDate(), mbMessage.getModifiedDate(), this._classNameLocalService.getClassNameId(CalendarBooking.class.getName()), calendarBookingId, mbMessage.getCategoryId(), threadId, mbMessage.getRootMessageId(), mbMessage.getParentMessageId(), mbMessage.getSubject(), mbMessage.getBody(), mbMessage.getFormat(), mbMessage.isAnonymous(), mbMessage.getPriority(), mbMessage.isAllowPingbacks(), mbMessage.isAnswer(), mbMessage.getStatus(), mbMessage.getStatusByUserId(), mbMessage.getStatusByUserName(), mbMessage.getStatusDate(), mbMessageIds);
        this._importRatings(MBDiscussion.class.getName(), mbMessage.getMessageId(), MBDiscussion.class.getName(), messageId);
        mbMessageIds.put(mbMessage.getMessageId(), messageId);
        return messageId;
    }

    private long _importMBThread(long threadId, long calendarBookingId) throws PortalException {
        MBThread mbThread = this._mbThreadLocalService.fetchMBThread(threadId);
        return this._importMBThread(mbThread, calendarBookingId);
    }

    private long _importMBThread(MBThread mbThread, long calendarBookingId) throws PortalException {
        long threadId = this._counterLocalService.increment();
        this._addMBThread(PortalUUIDUtil.generate(), threadId, mbThread.getGroupId(), mbThread.getCompanyId(), mbThread.getUserId(), mbThread.getUserName(), mbThread.getCreateDate(), mbThread.getModifiedDate(), mbThread.getCategoryId(), 0L, mbThread.getRootMessageUserId(), mbThread.getTitle(), mbThread.getMessageCount(), mbThread.getViewCount(), mbThread.getLastPostByUserId(), mbThread.getLastPostDate(), mbThread.getPriority(), mbThread.isQuestion(), mbThread.getStatus(), mbThread.getStatusByUserId(), mbThread.getStatusByUserName(), mbThread.getStatusDate());
        HashMap<Long, Long> mbMessageIds = new HashMap<Long, Long>();
        List mbMessages = this._mbMessageLocalService.getThreadMessages(mbThread.getThreadId(), -1);
        for (MBMessage mbMessage : mbMessages) {
            this._importMBMessage(mbMessage, threadId, calendarBookingId, mbMessageIds);
        }
        this._updateMBThreadRootMessageId(threadId, (Long)mbMessageIds.get(mbThread.getRootMessageId()));
        return threadId;
    }

    private void _importRatings(String oldClassName, long oldClassPK, String className, long classPK) {
        List ratingsEntries = this._ratingsEntryLocalService.getEntries(oldClassName, oldClassPK);
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            this._addRatingsEntry(this._counterLocalService.increment(), ratingsEntry.getCompanyId(), ratingsEntry.getUserId(), ratingsEntry.getUserName(), ratingsEntry.getCreateDate(), ratingsEntry.getModifiedDate(), className, classPK, ratingsEntry.getScore());
        }
        RatingsStats ratingsStats = this._ratingsStatsLocalService.fetchStats(oldClassName, oldClassPK);
        if (ratingsStats == null) {
            return;
        }
        this._addRatingsStats(this._counterLocalService.increment(), className, classPK, ratingsStats.getTotalEntries(), ratingsStats.getTotalScore(), ratingsStats.getAverageScore());
    }

    private void _importSocialActivities(long eventId, long calendarBookingId) {
        List socialActivities = this._socialActivityLocalService.getActivities(_CLASS_NAME, -1, -1);
        for (SocialActivity socialActivity : socialActivities) {
            if (socialActivity.getClassPK() != eventId) continue;
            this._importSocialActivity(socialActivity, calendarBookingId);
        }
    }

    private void _importSocialActivity(SocialActivity socialActivity, long calendarBookingId) {
        this._addSocialActivity(this._counterLocalService.increment(SocialActivity.class.getName()), socialActivity.getGroupId(), socialActivity.getCompanyId(), socialActivity.getUserId(), socialActivity.getCreateDate(), socialActivity.getMirrorActivityId(), this._classNameLocalService.getClassNameId(CalendarBooking.class), calendarBookingId, socialActivity.getType(), socialActivity.getExtraData(), socialActivity.getReceiverUserId());
    }

    private void _importSubscription(Subscription subscription, long calendarBookingId) {
        this._addSubscription(this._counterLocalService.increment(), subscription.getCompanyId(), subscription.getUserId(), subscription.getUserName(), subscription.getCreateDate(), subscription.getModifiedDate(), this._classNameLocalService.getClassNameId(CalendarBooking.class), calendarBookingId, subscription.getFrequency());
    }

    private void _importSubscriptions(long companyId, long eventId, long calendarBookingId) {
        List subscriptions = this._subscriptionLocalService.getSubscriptions(companyId, _CLASS_NAME, eventId);
        for (Subscription subscription : subscriptions) {
            this._importSubscription(subscription, calendarBookingId);
        }
    }

    private boolean _isAssetLinkImported(long entryId1, long entryId2, int type) throws SQLException {
        StringBundler sb = new StringBundler(3);
        sb.append("select count(*) from AssetLink where ((entryId1 = ? and ");
        sb.append("entryId2 = ?) or (entryId2 = ? and entryId1 = ?)) and ");
        sb.append("type_ = ?");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setLong(1, entryId1);
            ps.setLong(2, entryId2);
            ps.setLong(3, entryId1);
            ps.setLong(4, entryId2);
            ps.setInt(5, type);
            ResultSet rs = ps.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void _updateMBThreadRootMessageId(long threadId, long rootMessageId) throws PortalException {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(threadId);
        mbThread.setRootMessageId(rootMessageId);
        this._mbThreadLocalService.updateMBThread(mbThread);
    }
}

