/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.persistence.impl;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.impl.BlogsEntryImpl;
import com.liferay.blogs.service.persistence.BlogsEntryFinder;
import com.liferay.blogs.service.persistence.impl.BlogsEntryFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BlogsEntryFinder.class})
public class BlogsEntryFinderImpl
extends BlogsEntryFinderBaseImpl
implements BlogsEntryFinder {
    public static final String COUNT_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".countByOrganizationIds";
    public static final String FIND_BY_GROUP_IDS = BlogsEntryFinder.class.getName() + ".findByGroupIds";
    public static final String FIND_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".findByOrganizationIds";
    public static final String FIND_BY_NO_ASSETS = BlogsEntryFinder.class.getName() + ".findByNoAssets";
    @Reference
    private CustomSQL _customSQL;

    public int countByOrganizationId(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.countByOrganizationIds(ListUtil.fromArray((Object[])new Long[]{organizationId}), displayDate, queryDefinition);
    }

    public int countByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status != ?)") : this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (Long organizationId : organizationIds) {
                queryPos.add(organizationId);
            }
            queryPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByGroupIds(long companyId, long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_GROUP_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status != ?)") : this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status = ?)");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(groupId);
            queryPos.add(groupId);
            queryPos.add(groupId);
            queryPos.add(displayDate);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByOrganizationId(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.findByOrganizationIds(ListUtil.fromArray((Object[])new Long[]{organizationId}), displayDate, queryDefinition);
    }

    public List<BlogsEntry> findByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status != ?)") : this._customSQL.appendCriteria(sql, "AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (Long organizationId : organizationIds) {
                queryPos.add(organizationId);
            }
            queryPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

