/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.service.impl;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.base.BlogsEntryServiceBaseImpl;
import com.liferay.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.blogs.util.comparator.EntryIdComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import com.liferay.rss.util.RSSUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=blogs", "json.web.service.context.path=BlogsEntry"}, service={AopService.class})
public class BlogsEntryServiceImpl
extends BlogsEntryServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private volatile ModelResourcePermission<BlogsEntry> _blogsEntryModelResourcePermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(resource.name=com.liferay.blogs)")
    private volatile PortletResourcePermission _portletResourcePermission;
    @Reference
    private RSSExporter _rssExporter;
    @Reference
    private SyndModelFactory _syndModelFactory;

    public FileEntry addAttachmentFileEntry(String externalReferenceCode, long groupId, String fileName, String mimeType, InputStream inputStream) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_ENTRY");
        return this.blogsEntryLocalService.addAttachmentFileEntry(externalReferenceCode, this.getUserId(), groupId, fileName, mimeType, inputStream);
    }

    public Folder addAttachmentsFolder(long groupId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_ENTRY");
        return this.blogsEntryLocalService.addAttachmentsFolder(this.getUserId(), groupId);
    }

    public BlogsEntry addEntry(String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_ENTRY");
        return this.blogsEntryLocalService.addEntry(this.getUserId(), title, subtitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public BlogsEntry addEntry(String externalReferenceCode, String title, String subtitle, String urlTitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_ENTRY");
        return this.blogsEntryLocalService.addEntry(externalReferenceCode, this.getUserId(), title, subtitle, urlTitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public void deleteAttachmentFileEntry(long fileEntryId) throws PortalException {
        FileEntry fileEntry = this.blogsEntryLocalService.getAttachmentFileEntry(fileEntryId);
        this._fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "DELETE");
        this.blogsEntryLocalService.deleteAttachmentFileEntry(fileEntryId);
    }

    public void deleteEntry(long entryId) throws PortalException {
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.blogsEntryLocalService.deleteEntry(entryId);
    }

    public BlogsEntry fetchBlogsEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        BlogsEntry blogsEntry = this.blogsEntryPersistence.fetchByERC_G(externalReferenceCode, groupId);
        if (blogsEntry != null) {
            this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)blogsEntry, "VIEW");
        }
        return blogsEntry;
    }

    public FileEntry getAttachmentFileEntry(long fileEntryId) throws PortalException {
        FileEntry fileEntry = this.blogsEntryLocalService.getAttachmentFileEntry(fileEntryId);
        this._fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "VIEW");
        return fileEntry;
    }

    public FileEntry getAttachmentFileEntryByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        FileEntry fileEntry = this.blogsEntryLocalService.getAttachmentFileEntryByExternalReferenceCode(externalReferenceCode, groupId);
        this._fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "VIEW");
        return fileEntry;
    }

    public BlogsEntry getBlogsEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        BlogsEntry entry = this.blogsEntryLocalService.getBlogsEntryByExternalReferenceCode(externalReferenceCode, groupId);
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)entry, "VIEW");
        return entry;
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int max) throws PortalException {
        ArrayList<BlogsEntry> blogsEntries1 = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)EntryDisplayDateComparator.getInstance((boolean)false));
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (blogsEntries1.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List blogsEntries2 = this.blogsEntryLocalService.getCompanyEntries(companyId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = blogsEntries2.size() == max;
            for (BlogsEntry blogsEntry : blogsEntries2) {
                if (blogsEntries1.size() >= max) continue block0;
                if (!this._blogsEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)blogsEntry, "VIEW")) continue;
                blogsEntries1.add(blogsEntry);
            }
        }
        return blogsEntries1;
    }

    public String getCompanyEntriesRSS(long companyId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        String name = company.getName();
        List<BlogsEntry> blogsEntries = this.getCompanyEntries(companyId, displayDate, status, max);
        return this._exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)entry, "VIEW");
        BlogsEntry[] entries = this.blogsEntryPersistence.filterFindByG_D_S_PrevAndNext(entryId, entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)EntryIdComparator.getInstance((boolean)true));
        if (entries[0] == null) {
            entries[0] = this.blogsEntryPersistence.fetchByG_LtD_S_Last(entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)EntryDisplayDateComparator.getInstance((boolean)true));
            if (entries[0] != null && !this._blogsEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)entries[0], "VIEW")) {
                entries[0] = null;
            }
        }
        if (entries[2] == null) {
            entries[2] = this.blogsEntryPersistence.fetchByG_GtD_S_First(entry.getGroupId(), entry.getDisplayDate(), 0, (OrderByComparator)EntryDisplayDateComparator.getInstance((boolean)true));
            if (entries[2] != null && !this._blogsEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)entries[2], "VIEW")) {
                entries[2] = null;
            }
        }
        return entries;
    }

    public BlogsEntry getEntry(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(entryId);
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)entry, "VIEW");
        return entry;
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(groupId, urlTitle);
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)entry, "VIEW");
        return entry;
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int max) {
        return this.getGroupEntries(groupId, displayDate, status, 0, max);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_LtD_NotS(groupId, displayDate, 8, start, end);
        }
        return this.blogsEntryPersistence.filterFindByG_LtD_S(groupId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int max) {
        return this.getGroupEntries(groupId, status, 0, max);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_NotS(groupId, 8, start, end);
        }
        return this.blogsEntryPersistence.filterFindByG_S(groupId, status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end, OrderByComparator<BlogsEntry> orderByComparator) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_NotS(groupId, 8, start, end, orderByComparator);
        }
        return this.blogsEntryPersistence.filterFindByG_S(groupId, status, start, end, orderByComparator);
    }

    public int getGroupEntriesCount(long groupId, Date displayDate, int status) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterCountByG_LtD_NotS(groupId, displayDate, 8);
        }
        return this.blogsEntryPersistence.filterCountByG_LtD_S(groupId, displayDate, status);
    }

    public int getGroupEntriesCount(long groupId, int status) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterCountByG_NotS(groupId, 8);
        }
        return this.blogsEntryPersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupEntriesRSS(long groupId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        String name = group.getDescriptiveName();
        List<BlogsEntry> blogsEntries = this.getGroupEntries(groupId, displayDate, status, max);
        return this._exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, int status, int max) throws PortalException {
        ArrayList<BlogsEntry> blogsEntries1 = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)EntryDisplayDateComparator.getInstance((boolean)false));
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (blogsEntries1.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List blogsEntries2 = this.blogsEntryLocalService.getGroupsEntries(companyId, groupId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = blogsEntries2.size() == max;
            for (BlogsEntry blogsEntry : blogsEntries2) {
                if (blogsEntries1.size() >= max) continue block0;
                if (!this._blogsEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)blogsEntry, "VIEW")) continue;
                blogsEntries1.add(blogsEntry);
            }
        }
        return blogsEntries1;
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int status, int start, int end, OrderByComparator<BlogsEntry> orderByComparator) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_U_NotS(groupId, userId, 8, start, end, orderByComparator);
        }
        return this.blogsEntryPersistence.filterFindByG_U_S(groupId, userId, status, start, end, orderByComparator);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int[] statuses, int start, int end, OrderByComparator<BlogsEntry> orderByComparator) {
        return this.blogsEntryPersistence.filterFindByG_U_S(groupId, userId, statuses, start, end, orderByComparator);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, int status) {
        if (status == -1) {
            return this.blogsEntryPersistence.filterCountByG_U_NotS(groupId, userId, 8);
        }
        return this.blogsEntryPersistence.filterCountByG_U_S(groupId, userId, status);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, int[] statuses) {
        return this.blogsEntryPersistence.filterCountByG_U_S(groupId, userId, statuses);
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int max) throws PortalException {
        ArrayList<BlogsEntry> blogsEntries1 = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)EntryDisplayDateComparator.getInstance((boolean)false));
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (blogsEntries1.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List blogsEntries2 = this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = blogsEntries2.size() == max;
            for (BlogsEntry blogsEntry : blogsEntries2) {
                if (blogsEntries1.size() >= max) continue block0;
                if (!this._blogsEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)blogsEntry, "VIEW")) continue;
                blogsEntries1.add(blogsEntry);
            }
        }
        return blogsEntries1;
    }

    public String getOrganizationEntriesRSS(long organizationId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Organization organization = this._organizationLocalService.getOrganization(organizationId);
        String name = organization.getName();
        List<BlogsEntry> blogsEntries = this.getOrganizationEntries(organizationId, displayDate, status, max);
        return this._exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry moveEntryToTrash(long entryId) throws PortalException {
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        return this.blogsEntryLocalService.moveEntryToTrash(this.getUserId(), entryId);
    }

    public void restoreEntryFromTrash(long entryId) throws PortalException {
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.blogsEntryLocalService.restoreEntryFromTrash(this.getUserId(), entryId);
    }

    public void subscribe(long groupId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.blogsEntryLocalService.subscribe(this.getUserId(), groupId);
    }

    public void unsubscribe(long groupId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.blogsEntryLocalService.unsubscribe(this.getUserId(), groupId);
    }

    public BlogsEntry updateEntry(long entryId, String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        return this.updateEntry(entryId, title, subtitle, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    public BlogsEntry updateEntry(long entryId, String title, String subtitle, String urlTitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, String coverImageCaption, ImageSelector coverImageImageSelector, ImageSelector smallImageImageSelector, ServiceContext serviceContext) throws PortalException {
        this._blogsEntryModelResourcePermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.blogsEntryLocalService.updateEntry(this.getUserId(), entryId, title, subtitle, urlTitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
    }

    private String _exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<BlogsEntry> blogsEntries, ThemeDisplay themeDisplay) {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(description);
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        for (BlogsEntry entry : blogsEntries) {
            SyndEntry syndEntry = this._syndModelFactory.createSyndEntry();
            syndEntry.setAuthor(this._portal.getUserName((BaseModel)entry));
            SyndContent syndContent = this._syndModelFactory.createSyndContent();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                String summary = entry.getDescription();
                if (Validator.isNull((String)summary)) {
                    summary = entry.getContent();
                }
                value = StringUtil.shorten((String)this._htmlParser.extractText(summary), (int)PropsValues.BLOGS_RSS_ABSTRACT_LENGTH, (String)"");
            } else {
                value = displayStyle.equals("title") ? "" : StringUtil.replace((String)entry.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
            }
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            StringBundler sb = new StringBundler(4);
            sb.append(entryURL);
            if (!entryURL.endsWith("?")) {
                sb.append("&");
            }
            sb.append("entryId=");
            sb.append(entry.getEntryId());
            String link = sb.toString();
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(entry.getDisplayDate());
            syndEntry.setTitle(entry.getTitle());
            syndEntry.setUpdatedDate(entry.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink selfSyndLink = this._syndModelFactory.createSyndLink();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return this._rssExporter.export(syndFeed);
    }
}

