/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.util.StagingAssetEntryHelper;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagingAssetEntryHelper.class})
public class StagingAssetEntryHelperImpl
implements StagingAssetEntryHelper {
    private static final Log _log = LogFactoryUtil.getLog(StagingAssetEntryHelperImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void addAssetReference(PortletDataContext portletDataContext, ClassedModel classedModel, Element stagedElement, AssetEntry assetEntry) {
        AssetRenderer assetRenderer = null;
        StagedModel stagedModel = null;
        try {
            assetRenderer = assetEntry.getAssetRenderer();
            stagedModel = (StagedModel)assetRenderer.getAssetObject();
        }
        catch (Exception exception) {
            return;
        }
        if (stagedModel == null) {
            return;
        }
        portletDataContext.addReferenceElement(classedModel, stagedElement, (ClassedModel)stagedModel, "disposable_dependency", true);
    }

    public AssetEntry fetchAssetEntry(long groupId, String uuid) throws PortalException {
        DynamicQuery dynamicQuery = this._assetEntryLocalService.dynamicQuery();
        Property classUuidProperty = PropertyFactoryUtil.forName((String)"classUuid");
        dynamicQuery.add(classUuidProperty.eq((Object)uuid));
        List assetEntries = this._assetEntryLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isEmpty((List)assetEntries)) {
            return null;
        }
        HashMap<Long, AssetEntry> assetEntryMap = new HashMap<Long, AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            assetEntryMap.put(assetEntry.getGroupId(), assetEntry);
        }
        if (assetEntryMap.containsKey(groupId)) {
            return (AssetEntry)assetEntryMap.get(groupId);
        }
        Group group = this._groupLocalService.getGroup(groupId);
        for (Group parentGroup = group.getParentGroup(); parentGroup != null; parentGroup = parentGroup.getParentGroup()) {
            AssetEntry assetEntry;
            if (!assetEntryMap.containsKey(parentGroup.getGroupId()) || !this.isAssetEntryApplicable(assetEntry = (AssetEntry)assetEntryMap.get(parentGroup.getGroupId()))) continue;
            return assetEntry;
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(group.getCompanyId());
        if (assetEntryMap.containsKey(companyGroup.getGroupId())) {
            return (AssetEntry)assetEntryMap.get(companyGroup.getGroupId());
        }
        Stream assetEntryStream = assetEntries.stream();
        List companyAssetEntries = assetEntryStream.filter(entry -> entry.getCompanyId() == group.getCompanyId()).collect(Collectors.toList());
        if (ListUtil.isEmpty(companyAssetEntries)) {
            return null;
        }
        for (AssetEntry assetEntry : companyAssetEntries) {
            try {
                if (!this.isAssetEntryApplicable(assetEntry)) continue;
                return assetEntry;
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
        return null;
    }

    public boolean isAssetEntryApplicable(AssetEntry assetEntry) throws PortalException {
        StagedGroupedModel stagedGroupedModel;
        Group group;
        TrashedModel trashedModel;
        AssetRenderer assetRenderer = null;
        StagedModel stagedModel = null;
        try {
            assetRenderer = assetEntry.getAssetRenderer();
            stagedModel = (StagedModel)assetRenderer.getAssetObject();
        }
        catch (Exception exception) {
            return false;
        }
        if (stagedModel instanceof TrashedModel && (trashedModel = (TrashedModel)stagedModel).isInTrash()) {
            return false;
        }
        return !(stagedModel instanceof StagedGroupedModel) || !(group = this._groupLocalService.getGroup((stagedGroupedModel = (StagedGroupedModel)stagedModel).getGroupId())).isStagingGroup();
    }
}

