/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.util.AssetRendererFactoryLookup;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={AssetRendererFactoryLookup.class})
public class AssetRendererFactoryLookupImpl
implements AssetRendererFactoryLookup {
    private static final boolean _INDEX_ON_STARTUP = GetterUtil.getBoolean((String)PropsUtil.get((String)"index.on.startup"));
    private static final long _INDEX_ON_STARTUP_DELAY = GetterUtil.getLong((String)PropsUtil.get((String)"index.on.startup.delay"));
    private static final Log _log = LogFactoryUtil.getLog(AssetRendererFactoryLookupImpl.class);
    private Instant _activated;
    private final Map<String, CountDownLatch> _assetRenderFactoriesCountDownLatchMap = new ConcurrentHashMap<String, CountDownLatch>();
    private BundleContext _bundleContext;
    private final Set<String> _initializedAssetRendererFactories = ConcurrentHashMap.newKeySet();
    private ServiceTracker<AssetRendererFactory<?>, AssetRendererFactory<?>> _serviceTracker;

    public AssetRendererFactory<?> getAssetRendererFactoryByClassName(String className) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory != null || !this._isIndexOnStartupWithDelayEnabled() || this._isAssetRendererFactoryInitialized(className)) {
            return assetRendererFactory;
        }
        this._waitAssetRendererFactoryLoaded(className);
        this._initializedAssetRendererFactories.add(className);
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }

    public AssetRendererFactory<?> getAssetRendererFactoryByType(String type) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByType((String)type);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, AssetRendererFactory.class, (ServiceTrackerCustomizer)new AssetRendererFactoryServiceTrackerCustomizer());
        this._activated = Instant.now();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._serviceTracker = null;
    }

    private boolean _isAssetRendererFactoryInitialized(String className) {
        return this._initializedAssetRendererFactories.contains(className);
    }

    private boolean _isIndexOnStartupWithDelayEnabled() {
        return _INDEX_ON_STARTUP && _INDEX_ON_STARTUP_DELAY > 0L;
    }

    private long _secondsElapsedSinceActivated() {
        Instant now = Instant.now();
        Duration elapsedDuration = Duration.between(this._activated, now);
        return elapsedDuration.getSeconds();
    }

    private void _waitAssetRendererFactoryLoaded(String className) {
        block2: {
            CountDownLatch countDownLatch = this._assetRenderFactoriesCountDownLatchMap.computeIfAbsent(className, key -> new CountDownLatch(1));
            long secondsToWait = Math.max(0L, _INDEX_ON_STARTUP_DELAY - this._secondsElapsedSinceActivated());
            try {
                countDownLatch.await(secondsToWait, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isInfoEnabled()) break block2;
                _log.info((Object)"Interrupted while waiting to load asset renderer factory", (Throwable)interruptedException);
            }
        }
    }

    private class AssetRendererFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AssetRendererFactory<?>, AssetRendererFactory<?>> {
        private AssetRendererFactoryServiceTrackerCustomizer() {
        }

        public AssetRendererFactory<?> addingService(ServiceReference<AssetRendererFactory<?>> serviceReference) {
            AssetRendererFactory assetRendererFactory = (AssetRendererFactory)AssetRendererFactoryLookupImpl.this._bundleContext.getService(serviceReference);
            AssetRendererFactoryLookupImpl.this._assetRenderFactoriesCountDownLatchMap.computeIfPresent(assetRendererFactory.getClassName(), (key, countDownLatch) -> {
                countDownLatch.countDown();
                return countDownLatch;
            });
            return assetRendererFactory;
        }

        public void modifiedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> service) {
        }

        public void removedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> service) {
            AssetRendererFactoryLookupImpl.this._bundleContext.ungetService(serviceReference);
        }
    }
}

