/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.security.service.access.policy;

import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class AssetEntrySAPEntryActivator {
    private static final String _SAP_ENTRY_NAME = "ASSET_ENTRY_DEFAULT";
    private static final Log _log = LogFactoryUtil.getLog(AssetEntrySAPEntryActivator.class);
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private ServiceRegistration<PortalInstanceLifecycleListener> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new AssetEntryPortalInstanceLifecycleListener(), null);
    }

    protected void addSAPEntry(long companyId) throws PortalException {
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, _SAP_ENTRY_NAME);
        if (sapEntry != null) {
            return;
        }
        String allowedServiceSignatures = AssetEntryService.class.getName() + "#incrementViewCounter";
        Map titleMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)new AggregateResourceBundleLoader(new ResourceBundleLoader[]{new ClassResourceBundleLoader("content.Language", AssetEntrySAPEntryActivator.class.getClassLoader()), LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER}), (String)"service-access-policy-entry-default-asset-entry-title");
        this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), allowedServiceSignatures, true, true, _SAP_ENTRY_NAME, titleMap, new ServiceContext());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class AssetEntryPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private AssetEntryPortalInstanceLifecycleListener() {
        }

        public void portalInstanceRegistered(Company company) throws Exception {
            try {
                AssetEntrySAPEntryActivator.this.addSAPEntry(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
            }
        }
    }
}

