/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.list.provider;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.info.list.provider.InfoListProviderContext;
import com.liferay.info.pagination.Pagination;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Optional;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAssetsInfoListProvider {
    @Reference
    protected Portal portal;

    protected AssetEntryQuery getAssetEntryQuery(InfoListProviderContext infoListProviderContext, String orderByCol, String orderByType, Pagination pagination) {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        Company company = infoListProviderContext.getCompany();
        long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)company.getCompanyId(), (boolean)true);
        availableClassNameIds = ArrayUtil.filter((long[])availableClassNameIds, availableClassNameId -> {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)this.portal.getClassName(availableClassNameId.longValue()));
            return indexer != null;
        });
        assetEntryQuery.setClassNameIds(availableClassNameIds);
        assetEntryQuery.setEnablePermissions(true);
        Optional groupOptional = infoListProviderContext.getGroupOptional();
        if (groupOptional.isPresent()) {
            Group group = (Group)groupOptional.get();
            assetEntryQuery.setGroupIds(new long[]{group.getGroupId()});
        }
        if (pagination != null) {
            assetEntryQuery.setStart(pagination.getStart());
            assetEntryQuery.setEnd(pagination.getEnd());
        }
        assetEntryQuery.setOrderByCol1(orderByCol);
        assetEntryQuery.setOrderByType1(orderByType);
        assetEntryQuery.setOrderByCol2("createDate");
        assetEntryQuery.setOrderByType2("DESC");
        return assetEntryQuery;
    }
}

